/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Generics;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interner<T> {
    protected static Interner<Object> interner = Generics.newInterner();
    protected Map<T, WeakReference<T>> map = Generics.newWeakHashMap();

    public static Interner<Object> getGlobal() {
        return interner;
    }

    public static Interner<Object> setGlobal(Interner<Object> interner) {
        Interner<Object> oldInterner = Interner.interner;
        Interner.interner = interner;
        return oldInterner;
    }

    public static <T> T globalIntern(T o) {
        return (T)Interner.getGlobal().intern(o);
    }

    public void clear() {
        this.map = Generics.newWeakHashMap();
    }

    public T intern(T o) {
        WeakReference<T> ref = this.map.get(o);
        if (ref == null) {
            ref = Generics.newWeakReference(o);
            this.map.put(o, ref);
        }
        return ref.get();
    }

    public Set<T> internAll(Set<T> s) {
        HashSet<T> result = Generics.newHashSet();
        for (T o : s) {
            result.add(this.intern(o));
        }
        return result;
    }

    public int size() {
        return this.map.size();
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String str = args[i];
            System.out.println(Interner.globalIntern(str) == str);
        }
    }
}

