# Generated by default/object.tt
package Paws::CustomerProfiles::DomainStats;
  use Moose;
  has MeteringProfileCount => (is => 'ro', isa => 'Int');
  has ObjectCount => (is => 'ro', isa => 'Int');
  has ProfileCount => (is => 'ro', isa => 'Int');
  has TotalSize => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CustomerProfiles::DomainStats

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CustomerProfiles::DomainStats object:

  $service_obj->Method(Att1 => { MeteringProfileCount => $value, ..., TotalSize => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CustomerProfiles::DomainStats object:

  $result = $service_obj->Method(...);
  $result->Att1->MeteringProfileCount

=head1 DESCRIPTION

Usage-specific statistics about the domain.

=head1 ATTRIBUTES


=head2 MeteringProfileCount => Int

The number of profiles that you are currently paying for in the domain.
If you have more than 100 objects associated with a single profile,
that profile counts as two profiles. If you have more than 200 objects,
that profile counts as three, and so on.


=head2 ObjectCount => Int

The total number of objects in domain.


=head2 ProfileCount => Int

The total number of profiles currently in the domain.


=head2 TotalSize => Int

The total size, in bytes, of all objects in the domain.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CustomerProfiles>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

