# Generated by default/object.tt
package Paws::Macie2::SessionContextAttributes;
  use Moose;
  has CreationDate => (is => 'ro', isa => 'Str', request_name => 'creationDate', traits => ['NameInRequest']);
  has MfaAuthenticated => (is => 'ro', isa => 'Bool', request_name => 'mfaAuthenticated', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SessionContextAttributes

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SessionContextAttributes object:

  $service_obj->Method(Att1 => { CreationDate => $value, ..., MfaAuthenticated => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SessionContextAttributes object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationDate

=head1 DESCRIPTION

Provides information about the context in which temporary security
credentials were issued to an entity.

=head1 ATTRIBUTES


=head2 CreationDate => Str

The date and time, in UTC and ISO 8601 format, when the credentials
were issued.


=head2 MfaAuthenticated => Bool

Specifies whether the credentials were authenticated with a
multi-factor authentication (MFA) device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

