# 
# This file is part of Task-Metabase
# 
# This software is Copyright (c) 2010 by David Golden.
# 
# This is free software, licensed under:
# 
#   The Apache License, Version 2.0, January 2004
# 
use 5.008;
use strict;
use warnings;
package Task::Metabase;
# ABSTRACT: Install Metabase server related modules


1;

__END__
=pod

=head1 NAME

Task::Metabase - Install Metabase server related modules

=head1 VERSION

version 1.100760

=head1 TASK CONTENTS

=head2 Core Metabase Modules

=head3 Metabase::Fact 0.006

=head3 Metabase::Client::Simple 0.005

=head3 Metabase 0.005

=head2 CPAN Testers Facts and Utilities

=head3 CPAN::Testers::Report 1.999

=head3 CPAN::Testers::Metabase 1.999

=head3 CPAN::Testers::Common::Utils 0.001

=head2 Support Modules

Optional but improve performance

=head3 JSON::XS 2.00

=head1 PENDING INCLUSION:

  Metabase::Web 0.003 # not yet on CPAN

=head1 AUTHOR

  David Golden <dagolden@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2010 by David Golden.

This is free software, licensed under:

  The Apache License, Version 2.0, January 2004

=cut

