#include "uulib/splitmix.h"
#include "uulib/gettime.h"

/* based on splitmix64
 * https://xorshift.di.unimi.it/splitmix64.c
*/

static U64 sm_x;

void sm_srand() {
  struct timeval  tv;
  int             i, n;

  gettimeofday(&tv, 0);

  sm_x = gt_100ns64()
    ^ (U64)tv.tv_sec  << 16
    ^ (U64)tv.tv_usec << 32
    ^ (U64)getpid()   << 48;

  n = (tv.tv_sec ^ tv.tv_usec) & 0x1f;

  for (i=0; i<n; ++i)
    (void)sm_rand();
}

U64 sm_rand(void) {
  U64 z = (sm_x += 0x9e3779b97f4a7c15ULL);
  z = (z ^ (z >> 30)) * 0xbf58476d1ce4e5b9ULL;
  z = (z ^ (z >> 27)) * 0x94d049bb133111ebULL;
  return z ^ (z >> 31);
}

/* ex:set ts=2 sw=2 itab=spaces: */
