# This Makefile.PL for Authen-SASL-XS was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008;
use ExtUtils::MakeMaker;

use Devel::CheckLib;

my @inc_search = qw(/opt/local/include /usr/local/include);
my @lib_search = qw(/opt/local/lib64 /usr/local/lib64 /opt/local/lib /usr/local/lib);
my %args       = map {/^(\w+)=(.*)/} grep {/^\w+=/} @ARGV;
my $use_sasl2  = exists $args{DEFINE} and $args{DEFINE} =~ /-DSASL2/;

unless (exists $args{INC} or exists $args{LIB}) {

  my @incpath = grep {-d} @inc_search;
  my @libpath = grep {-d} @lib_search;
  my $have_sasl2 = eval {
    assert_lib(
      lib     => "sasl2",
      header  => "sasl/sasl.h",
      libpath => \@libpath,
      incpath => \@incpath
    );
    1;
  };

  if ($have_sasl2) {
    $args{DEFINE} = "-DSASL2" unless $use_sasl2;
  }
  else {
    exit(0) if $use_sasl2;
    @incpath = grep {-d} map { ("$_/sasl", $_) } @inc_search;
    check_lib_or_exit(
      lib     => "sasl",
      header  => "sasl.h",
      libpath => \@libpath,
      incpath => \@incpath
    );
  }

  $args{INC}  = join " ", map {"-I$_"} @incpath;
  $args{LIBS} = join " ", map {"-L$_"} @libpath;
  $args{LIBS} .= $have_sasl2 ? " -lsasl2" : " -lsasl";
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "XS code to glue Perl SASL to Cyrus SASL",
  "AUTHOR" => "Graham Barr <gmbarr\@gmail.com>",
  "CONFIGURE_REQUIRES" => {
    "Devel::CheckLib" => 0,
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Authen-SASL-XS",
  "LICENSE" => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME" => "Authen::SASL::XS",
  "PREREQ_PM" => {
    "Authen::SASL" => "2.08"
  },
  "TEST_REQUIRES" => {
    "Authen::SASL" => "2.08",
    "Test::More" => 0,
    "Test::Simple" => 0
  },
  "VERSION" => "1.02",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    %args,
);

my %FallbackPrereqs = (
  "Authen::SASL" => "2.08",
  "Test::More" => 0,
  "Test::Simple" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub postamble {
  return <<'POD';

XS.pod: XS.xs
	@echo "!!! Developers: Do not edit the XS.pod, edit the XS.xs instead. !!!"
	@echo "Make will overwrite XS.pod."
	- podselect XS.xs > XS.pod
POD
}
