/*
 * Fisoco : FInd, Select, Order and COnvert files
 * Copyright 2015-2016 (C) Felicien PILLOT <felicien.pillot@member.fsf.org>
 *
 * This file is part of Fisoco.
 *
 * Fisoco is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Fisoco is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Fisoco.  If not, see <http://www.gnu.org/licenses/>.
 *
 *//////////////////////////////////////
/***************
 *    cli.cc    *
 *    ~~~~~~    *
 ****************/

#include "../include/cli.h"
#include "../include/global.h"
#include "../include/search.h"

void
Cli::clean ()
{
  results = List ();
}

void
Cli::info (int number)
{
  std::vector<std::string> infos = results.get_infos (number);
  if (infos.size () == 0)
    error ("No information / File unknown : check the list by typing 'read'");
  else
    {
      char const *x[] = {"Name", "Path"};
      std::vector<std::string> keys (x, x + sizeof (x) / sizeof (*x));
      // Display
      std::cout << number;
      for (std::vector<std::string>::iterator info = infos.begin (), key = keys.begin (); info != infos.end (); info++, key++)
	std::cout << "\t -> " << *key << " : " << *info << std::endl;
      std::cout << std::endl;
    }
}

void
Cli::interactive_read ()
{
  if (!read ())
    std::cout << "List empty : no files searched, founded or selected" << std::endl;
}

void
Cli::notify (std::list<std::string> files, std::string dir)
{
  for (std::list<std::string>::iterator file = files.begin (); file != files.end (); file++)
    results.add_file (dir, *file);
}

int
Cli::read ()
{
  int i = 1;
  std::list<std::string> list_names = results.get_complete_names ();
  if (list_names.size () != 0)
    {
      for (std::list<std::string>::iterator complete_name = list_names.begin ();
	   complete_name != list_names.end (); complete_name++, i++)
	{
	  std::cout << i << "\t- " << *complete_name << std::endl;
	}
      return 1;
    }
  else
    return 0;
}

void
Cli::search (std::string arg)
{
  // New list
  results = List ();
  // Launch process
  start_search (arg);
  
  std::cout << arg << gettext (" is being searched. Type 'read' to see results (you may wait a while before all results are displayed).") << std::endl;
}

 int
 Cli::start_search (Glib::ustring search)
 {
     // Start a new worker thread.
     std::string dir = "/";
     // Start a new worker thread.
     cli_WorkerThread =
     Glib::Threads::Thread::
     create (
         sigc::bind
         (
             sigc::bind<Glib::ustring>
             (
                 sigc::bind<std::string>
                 (
                     sigc::mem_fun
                     (cli_Worker,
                      &Search::do_work_only),
                  dir),
              search),
          this));
     return 1;
 }
 
