/*
 * MicroEngine - A microkernel inspired game engine
 * Copyright (C) 2008 "Slinger" ("Sould Slinger" @ gorcx.net/forum),
 * _unless where otherwise stated_
 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.

 */

#include <stdio.h>
#include <string.h>
#include <SDL/SDL_loadso.h>
#include <sys/types.h>
#include <dirent.h>

//custom files
#include "plugins.c"
#include "scripts.c"

//hardcoded paths, just change these if you want others
#define plugin_dir "./data/plugins"
#define script_path "./data/init.script"

int main(void)
{
	printf(	"*\n*** MicroEngine v0.04 ***\n*\n"
		"\n* Copyright (C) 2008 \"Soul Slinger\" @ gorcx.net/forum\n"
	       	"* Unless where otherwise stated\n\n"
		"> This program comes WITHOUT ANY WARANTY\n"
		"> This is free, as in freedom, software: You can\n"
		"> redistribute it and/or modify it under the terms\n"
		"> of the GNU General Public License version 3 or\n"
		"> (at your option) any later version.\n\n" );
	#ifdef WINDOWS
		printf("compiled for windows, might not work... :p\n");
	#endif
	printf("(problems? make sure that PWD = path to microengine)\n\n");


	if (load_plugins (plugin_dir))
		return -1;

	if (load_script (0, script_path))
		return -1;

	//everything done, lets run the init and term scriptblocks
	//run_script (0, load); is always run at script load
	printf(">> Run init block:\n");
	run_script (0, init);
	printf(">> Run term block:\n");
	run_script (0, term);
	//run_script (0, unload); is always run at script unload
	printf("That's all!\n\n");

	unload_script(0);
	unload_plugins();
	printf("DONE!\n");
	return 0;
}
