/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyRep;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

final class SunJCE_ae
implements PBEKey {
    static final long serialVersionUID = -2234868909660948157L;
    private char[] a;
    private byte[] b;
    private int c;
    private byte[] d;
    private Mac e;

    private static byte[] a(char[] cArray) {
        Charset charset = Charset.forName("UTF-8");
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        ByteBuffer byteBuffer = charset.encode(charBuffer);
        int n = byteBuffer.limit();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray, 0, n);
        return byArray;
    }

    SunJCE_ae(PBEKeySpec pBEKeySpec, String string) throws InvalidKeySpecException {
        char[] cArray = pBEKeySpec.getPassword();
        this.a = cArray == null ? new char[0] : (char[])cArray.clone();
        byte[] byArray = SunJCE_ae.a(this.a);
        this.b = pBEKeySpec.getSalt();
        if (this.b == null) {
            throw new InvalidKeySpecException("Salt not found");
        }
        this.c = pBEKeySpec.getIterationCount();
        if (this.c == 0) {
            throw new InvalidKeySpecException("Iteration count not found");
        }
        if (this.c < 0) {
            throw new InvalidKeySpecException("Iteration count is negative");
        }
        int n = pBEKeySpec.getKeyLength();
        if (n == 0) {
            throw new InvalidKeySpecException("Key length not found");
        }
        if (n == 0) {
            throw new InvalidKeySpecException("Key length is negative");
        }
        try {
            this.e = Mac.getInstance(string, "SunJCE");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchAlgorithmException);
            throw invalidKeySpecException;
        }
        catch (NoSuchProviderException noSuchProviderException) {
            InvalidKeySpecException invalidKeySpecException = new InvalidKeySpecException();
            invalidKeySpecException.initCause(noSuchProviderException);
            throw invalidKeySpecException;
        }
        this.d = SunJCE_ae.a(this.e, byArray, this.b, this.c, n);
    }

    private static byte[] a(Mac mac, byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / 8;
        byte[] byArray3 = new byte[n3];
        try {
            int n4 = mac.getMacLength();
            int n5 = (n3 + n4 - 1) / n4;
            int n6 = n3 - (n5 - 1) * n4;
            byte[] byArray4 = new byte[n4];
            byte[] byArray5 = new byte[n4];
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, mac.getAlgorithm());
            mac.init(secretKeySpec);
            byte[] byArray6 = new byte[4];
            for (int i = 1; i <= n5; ++i) {
                mac.update(byArray2);
                byArray6[3] = (byte)i;
                byArray6[2] = (byte)(i >> 8 & 0xFF);
                byArray6[1] = (byte)(i >> 16 & 0xFF);
                byArray6[0] = (byte)(i >> 24 & 0xFF);
                mac.update(byArray6);
                mac.doFinal(byArray4, 0);
                System.arraycopy(byArray4, 0, byArray5, 0, byArray4.length);
                for (int j = 2; j <= n; ++j) {
                    mac.update(byArray4);
                    mac.doFinal(byArray4, 0);
                    for (int k = 0; k < byArray4.length; ++k) {
                        int n7 = k;
                        byArray5[n7] = (byte)(byArray5[n7] ^ byArray4[k]);
                    }
                }
                if (i == n5) {
                    System.arraycopy(byArray5, 0, byArray3, (i - 1) * n4, n6);
                    continue;
                }
                System.arraycopy(byArray5, 0, byArray3, (i - 1) * n4, n4);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new RuntimeException("Error deriving PBKDF2 keys");
        }
        return byArray3;
    }

    public byte[] getEncoded() {
        return (byte[])this.d.clone();
    }

    public String getAlgorithm() {
        return "PBKDF2With" + this.e.getAlgorithm();
    }

    public int getIterationCount() {
        return this.c;
    }

    public char[] getPassword() {
        return (char[])this.a.clone();
    }

    public byte[] getSalt() {
        return (byte[])this.b.clone();
    }

    public String getFormat() {
        return "RAW";
    }

    public int hashCode() {
        int n = 0;
        for (int i = 1; i < this.d.length; ++i) {
            n += this.d[i] * i;
        }
        return n ^= this.getAlgorithm().toLowerCase().hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SecretKey)) {
            return false;
        }
        SecretKey secretKey = (SecretKey)object;
        if (!secretKey.getAlgorithm().equalsIgnoreCase(this.getAlgorithm())) {
            return false;
        }
        if (!secretKey.getFormat().equalsIgnoreCase("RAW")) {
            return false;
        }
        byte[] byArray = secretKey.getEncoded();
        boolean bl = Arrays.equals(this.d, secretKey.getEncoded());
        Arrays.fill(byArray, (byte)0);
        return bl;
    }

    private Object writeReplace() throws ObjectStreamException {
        return new KeyRep(KeyRep.Type.SECRET, this.getAlgorithm(), this.getFormat(), this.getEncoded());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.a != null) {
                Arrays.fill(this.a, '0');
                this.a = null;
            }
            if (this.d != null) {
                Arrays.fill(this.d, (byte)0);
                this.d = null;
            }
        }
        finally {
            super.finalize();
        }
    }
}

