/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.WebServiceException;

class LogicalMessageImpl
implements LogicalMessage {
    private Packet packet;
    private Source payloadSrc = null;
    private boolean payloadModifed = false;

    public LogicalMessageImpl(Packet packet) {
        this.packet = packet;
    }

    boolean isPayloadModifed() {
        return this.payloadModifed;
    }

    Source getModifiedPayload() {
        if (!this.payloadModifed) {
            throw new RuntimeException("Payload not modified.");
        }
        return this.payloadSrc;
    }

    public Source getPayload() {
        if (!this.payloadModifed) {
            this.payloadSrc = this.packet.getMessage().readPayloadAsSource();
            this.payloadModifed = true;
        }
        if (this.payloadSrc == null) {
            return null;
        }
        if (this.payloadSrc instanceof DOMSource) {
            return this.payloadSrc;
        }
        try {
            Transformer transformer = XmlUtil.newTransformer();
            DOMResult dOMResult = new DOMResult();
            transformer.transform(this.payloadSrc, dOMResult);
            this.payloadSrc = new DOMSource(dOMResult.getNode());
            return this.payloadSrc;
        }
        catch (TransformerException transformerException) {
            throw new WebServiceException(transformerException);
        }
    }

    public void setPayload(Source source) {
        this.payloadModifed = true;
        this.payloadSrc = source;
    }

    public Object getPayload(JAXBContext jAXBContext) {
        try {
            Source source = this.getPayload();
            if (source == null) {
                return null;
            }
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            return unmarshaller.unmarshal(source);
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }

    public void setPayload(Object object, JAXBContext jAXBContext) {
        this.payloadModifed = true;
        try {
            Marshaller marshaller = jAXBContext.createMarshaller();
            marshaller.setProperty("jaxb.fragment", true);
            DOMResult dOMResult = new DOMResult();
            marshaller.marshal(object, dOMResult);
            this.payloadSrc = new DOMSource(dOMResult.getNode());
        }
        catch (JAXBException jAXBException) {
            throw new WebServiceException(jAXBException);
        }
    }
}

