/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import java.security.AccessController;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingHeavyWeight;
import sun.awt.AppContext;
import sun.awt.PaintEventDispatcher;
import sun.awt.SunToolkit;
import sun.awt.event.IgnorePaintEvent;
import sun.security.action.GetBooleanAction;
import sun.security.action.GetPropertyAction;

class SwingPaintEventDispatcher
extends PaintEventDispatcher {
    private static final boolean SHOW_FROM_DOUBLE_BUFFER = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.showFromDoubleBuffer", "true")));
    private static final boolean ERASE_BACKGROUND = AccessController.doPrivileged(new GetBooleanAction("swing.nativeErase"));

    SwingPaintEventDispatcher() {
    }

    public PaintEvent createPaintEvent(Component component, int n, int n2, int n3, int n4) {
        if (component instanceof RootPaneContainer) {
            AppContext appContext = SunToolkit.targetToAppContext(component);
            RepaintManager repaintManager = RepaintManager.currentManager(appContext);
            if (!SHOW_FROM_DOUBLE_BUFFER || !repaintManager.show((Container)component, n, n2, n3, n4)) {
                repaintManager.nativeAddDirtyRegion(appContext, (Container)component, n, n2, n3, n4);
            }
            return new IgnorePaintEvent(component, 800, new Rectangle(n, n2, n3, n4));
        }
        if (component instanceof SwingHeavyWeight) {
            AppContext appContext = SunToolkit.targetToAppContext(component);
            RepaintManager repaintManager = RepaintManager.currentManager(appContext);
            repaintManager.nativeAddDirtyRegion(appContext, (Container)component, n, n2, n3, n4);
            return new IgnorePaintEvent(component, 800, new Rectangle(n, n2, n3, n4));
        }
        return super.createPaintEvent(component, n, n2, n3, n4);
    }

    public boolean shouldDoNativeBackgroundErase(Component component) {
        return ERASE_BACKGROUND || !(component instanceof RootPaneContainer);
    }

    public boolean queueSurfaceDataReplacing(Component component, Runnable runnable) {
        if (component instanceof RootPaneContainer) {
            AppContext appContext = SunToolkit.targetToAppContext(component);
            RepaintManager.currentManager(appContext).nativeQueueSurfaceDataRunnable(appContext, component, runnable);
            return true;
        }
        return super.queueSurfaceDataReplacing(component, runnable);
    }
}

