/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.net.cookie;

import com.sun.deploy.config.Config;
import com.sun.deploy.net.cookie.CookieHandler;
import com.sun.deploy.net.cookie.CookieStore;
import com.sun.deploy.net.cookie.CookieUnavailableException;
import com.sun.deploy.net.cookie.HttpCookie;
import com.sun.deploy.net.cookie.NetscapeCookieStore;
import com.sun.deploy.net.cookie.SessionCookieStore;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class GenericCookieHandler
implements CookieHandler {
    private CookieStore sessionCookieStore = new SessionCookieStore();
    private CookieStore persistCookieStore;

    public GenericCookieHandler() {
        File file = new File(Config.getUserCookieFile());
        this.persistCookieStore = new NetscapeCookieStore(file);
    }

    public synchronized String getCookieInfo(URL uRL) throws CookieUnavailableException {
        try {
            if (uRL.getPath() == null || uRL.getPath().equals("")) {
                uRL = new URL(uRL, "/");
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new CookieUnavailableException(malformedURLException.getMessage(), malformedURLException);
        }
        return this.getRelevantCookies(uRL);
    }

    public synchronized void setCookieInfo(URL uRL, String string) throws CookieUnavailableException {
        this.recordCookie(uRL, string);
    }

    private void recordCookie(URL uRL, String string) {
        HttpCookie httpCookie = HttpCookie.create(uRL, string);
        if (httpCookie == null) {
            return;
        }
        String[] stringArray = new String[]{"com", "edu", "net", "org", "gov", "mil", "int"};
        String string2 = httpCookie.getDomain();
        if (string2 == null) {
            return;
        }
        string2 = string2.toLowerCase();
        String string3 = uRL.getHost();
        boolean bl = (string3 = string3.toLowerCase()).equals(string2);
        if (!bl && string3.endsWith(string2)) {
            int n;
            int n2 = 2;
            for (n = 0; n < stringArray.length; ++n) {
                if (!string2.endsWith(stringArray[n])) continue;
                n2 = 1;
            }
            n = string2.length();
            while (n > 0 && n2 > 0) {
                n = string2.lastIndexOf(46, n - 1);
                --n2;
            }
            if (n > 0) {
                bl = true;
            }
        }
        if (bl) {
            this.recordCookie(httpCookie);
        }
    }

    private void recordCookie(HttpCookie httpCookie) {
        if (!this.sessionCookieStore.shouldRejectCookie(httpCookie)) {
            this.sessionCookieStore.recordCookie(httpCookie);
        }
        if (!this.persistCookieStore.shouldRejectCookie(httpCookie)) {
            this.persistCookieStore.recordCookie(httpCookie);
        }
    }

    private String getRelevantCookies(URL uRL) {
        String string = this.sessionCookieStore.getRelevantCookies(uRL);
        String string2 = this.persistCookieStore.getRelevantCookies(uRL);
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + "; " + string2;
    }

    public static void main(String[] stringArray) {
        try {
            GenericCookieHandler genericCookieHandler = new GenericCookieHandler();
            URL uRL = new URL("http://java.sun.com/bar/index.html");
            URL uRL2 = new URL("http://java.sun.com");
            URL uRL3 = new URL("http://java.sun.com/xyz/bar/index.html");
            URL uRL4 = new URL("https://java.sun.com");
            URL uRL5 = new URL("https://java.sun.com/foo/xyz/index.html");
            URL uRL6 = new URL("https://java.sun.com/foobar/xyz/index.html");
            URL uRL7 = new URL("https://java.sun.com/xyz/foo/index.html");
            URL uRL8 = new URL("http://xyz.sun.com/");
            URL uRL9 = new URL("http://xyz.sun.com/ammo/index.html");
            System.out.println("Client --> " + uRL);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL));
            System.out.println("");
            System.out.println("Server --> " + uRL);
            System.out.println("Set-Cookie: CUSTOMER_EXPIRED=WILE_E_COYOTE_EXPIRED; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT");
            System.out.println("Set-Cookie: CUSTOMER_NOT_EXPIRED=WILE_E_COYOTE_NOT_EXPIRED; path=/; expires=Wednesday, 09-Nov-03 23:12:40 GMT");
            System.out.println("Set-Cookie: CUSTOMER_SECURE=WILE_E_COYOTE_SECURE; path=/; secure");
            System.out.println("");
            genericCookieHandler.setCookieInfo(uRL, "CUSTOMER_EXPIRED=WILE_E_COYOTE_EXPIRED; path=/; expires=Wednesday, 09-Nov-99 23:12:40 GMT");
            genericCookieHandler.setCookieInfo(uRL, "CUSTOMER_NOT_EXPIRED=WILE_E_COYOTE_NOT_EXPIRED; path=/; expires=Wednesday, 09-Nov-03 23:12:40 GMT");
            genericCookieHandler.setCookieInfo(uRL, "CUSTOMER_SECURE=WILE_E_COYOTE_SECURE; path=/; secure");
            System.out.println("Client --> " + uRL2);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL2));
            System.out.println("");
            System.out.println("Server --> " + uRL3);
            System.out.println("Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("");
            genericCookieHandler.setCookieInfo(uRL3, "PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("Client --> " + uRL2);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL2));
            System.out.println("");
            System.out.println("Server --> " + uRL);
            System.out.println("Set-Cookie: SHIPPING=FEDEX; path=/foo");
            System.out.println("Set-Cookie: SHIPPING_SECURE=UPS; path=/foo; secure");
            System.out.println("");
            genericCookieHandler.setCookieInfo(uRL, "SHIPPING=FEDEX; path=/foo");
            genericCookieHandler.setCookieInfo(uRL, "SHIPPING_SECURE=UPS; path=/foo; secure");
            System.out.println("Client --> " + uRL2);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL2));
            System.out.println("");
            System.out.println("Client --> " + uRL);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL));
            System.out.println("");
            System.out.println("Client --> " + uRL4);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL4));
            System.out.println("");
            System.out.println("Client --> " + uRL5);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL5));
            System.out.println("");
            System.out.println("Client --> " + uRL6);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL6));
            System.out.println("");
            System.out.println("Client --> " + uRL7);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL7));
            System.out.println("");
            System.out.println("Client --> " + uRL8);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL8));
            System.out.println("");
            System.out.println("Server --> " + uRL8);
            System.out.println("Set-Cookie: PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("");
            genericCookieHandler.setCookieInfo(uRL8, "PART_NUMBER=ROCKET_LAUNCHER_0001; path=/");
            System.out.println("Client --> " + uRL8);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL8));
            System.out.println("");
            System.out.println("Server --> " + uRL8);
            System.out.println("Set-Cookie: PART_NUMBER=RIDING_ROCKET_0023; path=/ammo");
            System.out.println("");
            genericCookieHandler.setCookieInfo(uRL8, "PART_NUMBER=RIDING_ROCKET_0023; path=/ammo");
            System.out.println("Client --> " + uRL9);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL9));
            System.out.println("");
            System.out.println("Client --> " + uRL8);
            System.out.println("Cookie\t  : " + genericCookieHandler.getCookieInfo(uRL8));
            System.out.println("");
            System.out.println(genericCookieHandler.sessionCookieStore.toString());
            System.out.println("");
            System.out.println(genericCookieHandler.persistCookieStore.toString());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }
}

