/* This is part of tmview, a dvi previewer. (c) 1995 Thomas Moor         */
/*                                                                       */
/* This program may be used without any warranty. It may be modified and */
/* distributed without any restrictions.                                 */


/* defs for the framebuffer version of tmview      */
/* will be copyed to "src/defs.h"           */
/* includes "src/defsgen.h"                 */

/* 
essential for I/O primitives and signalhandling:
don't use pure posix, use either BSD- or GNU-extensions.
*/

#define _GNU_SOURCE  

#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>  
#include <sys/fcntl.h>  
#include <sys/wait.h>  
#include <memory.h>
#include <unistd.h>
#include <signal.h>

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>


/* the framebuffer devive to use */
#define THEFBDEV "/dev/fb0"


/*
***************************************************************************
  startup values, commandline default:
  here only those which tend to be deveice/platform dependant.
  see "src/defsgen.h" for more options
***************************************************************************
*/


/* set defaults for the options -t, -f, -g and -n */
#define TFMDIR  "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define PKDIR   "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define VFDIR   "./:/usr/lib/texmf/fonts//:/usr/local/teTeX/texmf/fonts//"
#define PKNAME  "@N.@Mpk"


/* set defaults for the option -s */
/* and fallback systemwide startupfile */
#define STARTUPFILENAME "~/.dvifb"
#define SYSTEMSTARTUPFILENAME "/etc/dvifb"


/* Users kept asking about using kpathsea ... so: */
/* to use kpathsea, define KPATHSEA below. to use tmviews built in    */
/* font searching, don't define KPATHSEA.                             */
/* Since I'm not distributing KPATHSEA, you'll have to get the library*/
/* from somewhere. See CTAN. I did test with the library which comes  */
/* with dviljk-2.5. Note: it makes not much sense to use a kpathsea   */
/* different from the one of the rest of your TeX-installation. E.g.  */
/* teTeX users best use the kpathsea from the teTeX sources. After all*/
/* configuring tmview to go with kpathsea requires some knowhow ...   */
/*                                                                    */
/* I've located two different kinds of initializing kpathsea,         */
/* depending on which kpathsea is used (actually I've got this info   */
/* from the diff-file of debian/slink)  Below exactly one of          */
/* KPATHSEAOLDSTYLE and KPATHSEANEWSTYLE need to be defined to set up */
/* tmview to go with your kpathsea. To figure out the right choice,   */
/* visit your /usr//include/kpathsea/proginit.h: if it defines the    */
/* function kpse_init_prog to have 5 arguments by "P5H", then its     */
/* KPATHSEAOLDSTYLE. Probably, you will go into details and check the */
/* meaning of these arguments. See also "./tmview/src/tmview.c".      */
/* However, if kpse_init_prog is defined  to have 4 arguments ("P4H"),*/
/* its KPATHSEANEWSTYLE.                                              */ 
/*                                                                    */ 
/* Running MakeTeXPK by kpathsea within dvifb may be disabled below.  */
/* #define KPATHSEA */
#ifdef KPATHSEA
#define KPATHMODE NULL    /* put f.e. "cx" here, to consist on cx fonts */
#define KPATHMAKE 1       /* put 0 here, to disable MakeTeXPK           */
#define KPATHDEFF "cmr10" /* fallback font                              */
#define KPATHSEANEWSTYLE    /* new=fine for teTeX from debian(see above)*/ 
/*#define KPATHSEAOLDSTYLE*//* old=fine for NTeX from Slakware          */
#endif


/* support for eps-figurs by calling ghostscript */
#define LETSTRYGS  
/* disable gs as startup-default. user may enable rendering by typing <o>*/
/* #define GSDEFOFF */

/*#define GSBIN "/usr/bin/gs" *//* absolute path of binary */
#define GSBIN "gs"              /* name of binary, use $PATH to locate it */

/* extra pixel to avoid clipping .. */
#define GSEXTRAPXL 3  /* plus 3 pxl on screen */   
#define GSEXTRAPT 3   /* plus 3 1/72 in epsfile */

/* greyscaling for eps-files */
/*#define GSGREY 1  *//* 1x1 pxl <> turned off */
#define GSGREY 2      /* 2x2 pxl <> cheap      */
/*#define GSGREY 4  *//* 4x4 pxl <> expensive  */

/* bufferlength for reading from gs */
#define GSBLOCKLEN 8192L 

/* arguments for calling gs */
#define GSARGLEN 40              /* max length og args */
#define GSARG0 "gs"
#define GSARG1 "-sDEVICE=bit"
#define GSARG2 "-sOutputFile=-"
#define GSARG3 "-dNOPAUSE"
#define GSARG4 "-dSAFER"
#define GSARG5 "-q"
#define GSARGPATH "-I%s"
#define GSARGSIZE "-g%dx%d"
#define GSARGRES "-r%.2fx%.2f"
#define GSARGLAST "-"
#define GSCODEINTRO  " /SDict 200 dict def SDict begin /showpage { } def "
#define GSCODESCALE  " %.5f %.5f scale "
#define GSCODETRANS  " %.2f %.2f translate "
#define GSCODEROTATE " %.2f rotate " 
#define GSCODEFILE   " (%s) run "
#define GSCODEQUIT   " end showpage quit "


/* dummys for resolution */
#define VGAXDIM 0
#define VGAYDIM 0

/* a little support for color specials  */
#define LETSTRYCOLOR

/*
***************************************************************************
  more internal stuff, make tmview go with the framebuffer
***************************************************************************
*/

/* be careful with storge types !!! */
#define BMLONG32       /* for architectures where "long int" has 32bits, e.g. i386  */
/* #define BMLONG64  *//* for architectures where "long int" has 64bits, e.g. alpha */
/* #define GREYINBMU *//* waste memory. may be a bit faster    */

/* if DOSFILES is defined, a dosfilesystem is expected, */ 
/* incl. ugly naming conventions, like drive-letters and "\" instead ob "/". */
/* Dont use this with unix sytems */ 

/* #define DOSFILES */

/* yes, gnu does support the gnu-extensions to getcwd() ..*/
#define GNU_GETCWD

/* waiting for IO available: dont do polling */
#define VGAHASWAITIO 

/* if HASMOUSE is defined, tmview offers a little mousesupport */
/* however, only the mouse-system protocol is accepted. so you */
/* may have to run "gpm -R" in order to repeat/translate your  */
/* mouse-whatever protocol on /dev/gpmdata.  */
#define HASMOUSE                    /* have a little mousesoupport */
#define THEMOUSEDEV  "/dev/gpmdata" /* use "gpm -R" */
#define MOUSESPEED  3               /* speed of mousemotion */
/*#define TRACKBALL 1 */            /* scrolling by mouse only if button pressed */


/* #define HASWINDOWS   *//* the framebuffer itself is no window system */

/* 
the following sets the way things go on the screen resp. window.
tmview allways keeps the screen/windows contents in an internal
buffer. You must define exactly one of the below options.
 
To provide flickering, you may define NOTHINGONSCREEN, making
tmview updating the screen from the buffer when the drawings are 
compleeted. On some Systems this will result in the best performance, 
depending on the screen driver. 

Set ALLONSCREEN, to make tmview drawing allways directly to the screen/window.
This might result in higher performance, at the cost of some flickering.

Set CURSORSNOTONSCREEEN to get a mixture of the above: when only
cursormovement is to be drawn, use the buffer. If more than that is
to be drawn, dont use the buffer.

Set SCROLLONSCREEN to get a mixture of the above: when scrolling is to
be done, use an XRequest directly. Anything else is done in the buffer.

*/

#define ALLONSCREEN         0
#define NOTHINGONSCREEN     1 
#define CURSORSNOTONSCREEN  0
#define SCROLLONSCREEN      0



/*
************************************************************************
now there will be some colorstuff. colors are changable here. but it's
the best to leave this untouched ...
*************************************************************************
*/


/*
Bytes representing colors internaly ... will be one by one mapped
to the actual color palette using a 256 pseudocolor mode 
*/

#define  COLORS_PER_GREY   16      /* should be 2^BITS_PER_GREY */

#define  WHITECOL      0
#define  BLACKCOL      (COLORS_PER_GREY-1)
#define  BORDERCOL     COLORS_PER_GREY
#define  TEXTCOL       COLORS_PER_GREY+1
#define  TEXTBACKCOL   COLORS_PER_GREY+2
#define  FRAMECOL      COLORS_PER_GREY+3
#define  TFMCOL        COLORS_PER_GREY+4
#define  RECTCOL       COLORS_PER_GREY+5

#define  BACKCOLS      COLORS_PER_GREY+16 /* start at least transparent */
#define  MARKSCOL      COLORS_PER_GREY+17
#define  MARKHCOL      COLORS_PER_GREY+18
#define  FOUNDCOL      COLORS_PER_GREY+19
#define  HREFCOL       COLORS_PER_GREY+20
#define  MARKDCOL      COLORS_PER_GREY+21
#define  MIXEDCOL      COLORS_PER_GREY+22 /* mixed all                  */

#define  NUMBER_OF_COLORS  COLORS_PER_GREY+23 /*number of colors */



/* definition of some rgb triples, 16-bit-per-componente   */
/* in fact beside of greyscales no other colors are used.  */
/* to make green more blue, edit here.                     */
/* if you have a grey-scale-only display, set  dark colors */
/* to dark grey and light colors to light grey.            */

#define PALWHITE 65535,65535,65535   /* white */
#define PALLGREY 56448,56448,56448   /* light grey */
#define PALBLACK 0,0,0               /* black */
#define PALDRED 41088,10368,5248     /* dark red */
#define PALDGREEN 0,41088,10368      /* dark green */
#define PALDBLUE 3200,10368,41088    /* dark blue */
#define PALLRED 65535,51328,44118    /* light red */
#define PALLGREEN 41088,65535,51328  /* light green */
#define PALLBLUE 44118,51328,65535   /* light blue */


/* definition of colors                                     */
/* this determines the colors on the display                */
/* the following may be changed without any (?) restictions.*/
/* setting                                                  */ 
/* #define SETPALFRAMECOL FRAMECOL,0,63,0                   */
/* results in having a bright green as framecolor           */

#define SETPALTEXTCOL     TEXTCOL,PALBLACK 
#define SETPALTEXTBACKCOL TEXTBACKCOL,PALLGREY 
#define SETPALFRAMECOL	  FRAMECOL,PALDRED
#define SETPALBORDERCOL   BORDERCOL,PALDGREEN
#define SETPALTFMCOL      TFMCOL,PALDBLUE
#define SETPALRECTCOL     RECTCOL,PALDBLUE 
#define SETPALMARKSCOL    MARKSCOL,PALLBLUE      
#define SETPALMARKHCOL    MARKHCOL,PALLGREEN
#define SETPALFOUNDCOL    FOUNDCOL,PALLGREEN    
#define SETPALHREFCOL     HREFCOL,PALLBLUE
#define SETPALMARKDCOL    MARKDCOL,PALLRED
#define SETPALMIXEDCOL    MIXEDCOL,PALLGREY




/*
***************************************************************************
  include general topics
***************************************************************************
*/

#include "defsgen.h"


