/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.volume;

import java.io.IOException;
import java.util.Objects;
import org.apache.accumulo.core.util.CachedConfiguration;
import org.apache.accumulo.core.volume.Volume;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VolumeImpl
implements Volume {
    private static final Logger log = LoggerFactory.getLogger(VolumeImpl.class);
    protected final FileSystem fs;
    protected final String basePath;

    public VolumeImpl(Path path, Configuration conf) throws IOException {
        Objects.requireNonNull(path);
        Objects.requireNonNull(conf);
        this.fs = path.getFileSystem(conf);
        this.basePath = path.toUri().getPath();
    }

    public VolumeImpl(FileSystem fs, String basePath) {
        Objects.requireNonNull(fs);
        Objects.requireNonNull(basePath);
        this.fs = fs;
        this.basePath = basePath;
    }

    @Override
    public FileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public Path prefixChild(Path p) {
        return this.fs.makeQualified(new Path(this.basePath, p));
    }

    @Override
    public boolean isValidPath(Path p) {
        FileSystem other;
        Objects.requireNonNull(p);
        try {
            other = p.getFileSystem(CachedConfiguration.getInstance());
        }
        catch (IOException e) {
            log.warn("Could not determine filesystem from path: " + p);
            return false;
        }
        if (this.equivalentFileSystems(other)) {
            return this.equivalentPaths(p);
        }
        return false;
    }

    boolean equivalentFileSystems(FileSystem other) {
        return this.fs.getUri().equals(other.getUri());
    }

    boolean equivalentPaths(Path other) {
        return other.toUri().getPath().startsWith(this.basePath);
    }

    public int hashCode() {
        return Objects.hashCode(this.getFileSystem()) + Objects.hashCode(this.getBasePath());
    }

    public boolean equals(Object o) {
        if (o instanceof VolumeImpl) {
            VolumeImpl other = (VolumeImpl)o;
            return this.getFileSystem().equals(other.getFileSystem()) && this.getBasePath().equals(other.getBasePath());
        }
        return false;
    }

    public String toString() {
        return this.getFileSystem() + " " + this.basePath;
    }

    @Override
    public Path prefixChild(String p) {
        return this.prefixChild(new Path(this.basePath, p));
    }
}

