/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.examples.simple.client;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowOperations {
    private static final Logger log = LoggerFactory.getLogger(RowOperations.class);
    private static Connector connector;
    private static String tableName;
    private static BatchWriter bw;

    public static void main(String[] args) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException {
        ClientOpts opts = new ClientOpts();
        ScannerOpts scanOpts = new ScannerOpts();
        BatchWriterOpts bwOpts = new BatchWriterOpts();
        opts.parseArgs(RowOperations.class.getName(), args, new Object[]{scanOpts, bwOpts});
        connector = opts.getConnector();
        connector.tableOperations().create(tableName);
        Text row1 = new Text("row1");
        Text row2 = new Text("row2");
        Text row3 = new Text("row3");
        Mutation mut1 = new Mutation(row1);
        Mutation mut2 = new Mutation(row2);
        Mutation mut3 = new Mutation(row3);
        Text col1 = new Text("1");
        Text col2 = new Text("2");
        Text col3 = new Text("3");
        Text col4 = new Text("4");
        mut1.put(new Text("column"), col1, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut1.put(new Text("column"), col2, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut1.put(new Text("column"), col3, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut1.put(new Text("column"), col4, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut2.put(new Text("column"), col1, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut2.put(new Text("column"), col2, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut2.put(new Text("column"), col3, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut2.put(new Text("column"), col4, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut3.put(new Text("column"), col1, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut3.put(new Text("column"), col2, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut3.put(new Text("column"), col3, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        mut3.put(new Text("column"), col4, System.currentTimeMillis(), new Value("This is the value for this key".getBytes(StandardCharsets.UTF_8)));
        bw = connector.createBatchWriter(tableName, bwOpts.getBatchWriterConfig());
        bw.addMutation(mut1);
        bw.addMutation(mut2);
        bw.addMutation(mut3);
        bw.flush();
        Scanner rowThree = RowOperations.getRow(scanOpts, new Text("row3"));
        Scanner rowTwo = RowOperations.getRow(scanOpts, new Text("row2"));
        Scanner rowOne = RowOperations.getRow(scanOpts, new Text("row1"));
        log.info("This is everything");
        RowOperations.printRow(rowOne);
        RowOperations.printRow(rowTwo);
        RowOperations.printRow(rowThree);
        System.out.flush();
        rowTwo = RowOperations.getRow(scanOpts, new Text("row2"));
        RowOperations.deleteRow(rowTwo);
        rowThree = RowOperations.getRow(scanOpts, new Text("row3"));
        rowTwo = RowOperations.getRow(scanOpts, new Text("row2"));
        rowOne = RowOperations.getRow(scanOpts, new Text("row1"));
        log.info("This is row1 and row3");
        RowOperations.printRow(rowOne);
        RowOperations.printRow(rowTwo);
        RowOperations.printRow(rowThree);
        System.out.flush();
        RowOperations.deleteRow(scanOpts, row1);
        rowThree = RowOperations.getRow(scanOpts, new Text("row3"));
        rowTwo = RowOperations.getRow(scanOpts, new Text("row2"));
        rowOne = RowOperations.getRow(scanOpts, new Text("row1"));
        log.info("This is just row3");
        RowOperations.printRow(rowOne);
        RowOperations.printRow(rowTwo);
        RowOperations.printRow(rowThree);
        System.out.flush();
        bw.close();
        connector.tableOperations().delete(tableName);
    }

    private static void deleteRow(ScannerOpts scanOpts, Text row) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        RowOperations.deleteRow(RowOperations.getRow(scanOpts, row));
    }

    private static void deleteRow(Scanner scanner) throws MutationsRejectedException {
        Mutation deleter = null;
        for (Map.Entry entry : scanner) {
            if (deleter == null) {
                deleter = new Mutation(((Key)entry.getKey()).getRow());
            }
            deleter.putDelete(((Key)entry.getKey()).getColumnFamily(), ((Key)entry.getKey()).getColumnQualifier());
        }
        bw.addMutation(deleter);
        bw.flush();
    }

    private static void printRow(Scanner scanner) {
        for (Map.Entry entry : scanner) {
            log.info("Key: " + ((Key)entry.getKey()).toString() + " Value: " + ((Value)entry.getValue()).toString());
        }
    }

    private static Scanner getRow(ScannerOpts scanOpts, Text row) throws AccumuloException, AccumuloSecurityException, TableNotFoundException {
        Scanner scanner = connector.createScanner(tableName, Authorizations.EMPTY);
        scanner.setBatchSize(scanOpts.scanBatchSize);
        scanner.setRange(new Range(row));
        return scanner;
    }

    static {
        tableName = "example";
    }
}

