/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test;

import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.test.MemoryUsageTest;
import org.apache.hadoop.io.Text;

class MutationMemoryUsageTest
extends MemoryUsageTest {
    private int keyLen;
    private int colFamLen;
    private int colQualLen;
    private int dataLen;
    private Mutation[] mutations;
    private Text key;
    private Text colf;
    private Text colq;
    private int passes;

    MutationMemoryUsageTest(int passes, int keyLen, int colFamLen, int colQualLen, int dataLen) {
        this.keyLen = keyLen;
        this.colFamLen = colFamLen;
        this.colQualLen = colQualLen;
        this.dataLen = dataLen;
        this.passes = passes;
        this.mutations = new Mutation[passes];
    }

    @Override
    void init() {
        this.key = new Text();
        this.colf = new Text(String.format("%0" + this.colFamLen + "d", 0));
        this.colq = new Text(String.format("%0" + this.colQualLen + "d", 0));
        byte[] data = new byte[this.dataLen];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)(i % 10 + 65);
        }
    }

    @Override
    public void addEntry(int i) {
        this.key.set(String.format("%0" + this.keyLen + "d", i));
        Mutation m = new Mutation(this.key);
        byte[] data = new byte[this.dataLen];
        for (int j = 0; j < data.length; ++j) {
            data[j] = (byte)(j % 10 + 65);
        }
        Value idata = new Value(data);
        m.put(this.colf, this.colq, idata);
        this.mutations[i] = m;
    }

    @Override
    public int getEstimatedBytesPerEntry() {
        return this.keyLen + this.colFamLen + this.colQualLen + this.dataLen;
    }

    @Override
    public void clear() {
        this.key = null;
        this.colf = null;
        this.colq = null;
        this.mutations = null;
    }

    @Override
    int getNumPasses() {
        return this.passes;
    }

    @Override
    String getName() {
        return "Mutation " + this.keyLen + " " + this.colFamLen + " " + this.colQualLen + " " + this.dataLen;
    }
}

