/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.continuous;

import com.beust.jcommander.Parameter;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.accumulo.core.cli.ClientOpts;
import org.apache.accumulo.core.cli.Help;

public class TimeBinner {
    private static DoubleWrapper get(long l, HashMap<Long, DoubleWrapper> m, double init) {
        DoubleWrapper dw = m.get(l);
        if (dw == null) {
            dw = new DoubleWrapper();
            dw.d = init;
            m.put(l, dw);
        }
        return dw;
    }

    public static void main(String[] args) throws Exception {
        Opts opts = new Opts();
        opts.parseArgs(TimeBinner.class.getName(), args, new Object[0]);
        Operation operation = Operation.valueOf(opts.operation);
        SimpleDateFormat sdf = new SimpleDateFormat(opts.dateFormat);
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, StandardCharsets.UTF_8));
        String line = null;
        HashMap<Long, DoubleWrapper> aggregation1 = new HashMap<Long, DoubleWrapper>();
        HashMap<Long, DoubleWrapper> aggregation2 = new HashMap<Long, DoubleWrapper>();
        HashMap<Long, DoubleWrapper> aggregation3 = new HashMap<Long, DoubleWrapper>();
        HashMap<Long, DoubleWrapper> aggregation4 = new HashMap<Long, DoubleWrapper>();
        while ((line = in.readLine()) != null) {
            try {
                String[] tokens = line.split("\\s+");
                long time = (long)Double.parseDouble(tokens[opts.timeColumn]);
                double data = Double.parseDouble(tokens[opts.dataColumn]);
                time = time / opts.period * opts.period;
                switch (operation) {
                    case AMM_HACK1: {
                        if (opts.dataColumn < 2) {
                            throw new IllegalArgumentException("--dataColumn must be at least 2");
                        }
                        double data_min = Double.parseDouble(tokens[opts.dataColumn - 2]);
                        double data_max = Double.parseDouble(tokens[opts.dataColumn - 1]);
                        TimeBinner.updateMin(time, aggregation3, data, data_min);
                        TimeBinner.updateMax(time, aggregation4, data, data_max);
                        TimeBinner.increment(time, aggregation1, data);
                        TimeBinner.increment(time, aggregation2, 1.0);
                        break;
                    }
                    case AMM: {
                        TimeBinner.updateMin(time, aggregation3, data, data);
                        TimeBinner.updateMax(time, aggregation4, data, data);
                        TimeBinner.increment(time, aggregation1, data);
                        TimeBinner.increment(time, aggregation2, 1.0);
                        break;
                    }
                    case AVG: {
                        TimeBinner.increment(time, aggregation1, data);
                        TimeBinner.increment(time, aggregation2, 1.0);
                        break;
                    }
                    case MAX: {
                        TimeBinner.updateMax(time, aggregation1, data, data);
                        break;
                    }
                    case MIN: {
                        TimeBinner.updateMin(time, aggregation1, data, data);
                        break;
                    }
                    case COUNT: {
                        TimeBinner.increment(time, aggregation1, 1.0);
                        break;
                    }
                    case SUM: 
                    case CUMULATIVE: {
                        TimeBinner.increment(time, aggregation1, data);
                    }
                }
            }
            catch (Exception e) {
                System.err.println("Failed to process line : " + line + "  " + e.getMessage());
            }
        }
        TreeMap sorted = new TreeMap(aggregation1);
        Set es = sorted.entrySet();
        double cumulative = 0.0;
        for (Map.Entry entry : es) {
            String value;
            switch (operation) {
                case AMM_HACK1: 
                case AMM: {
                    DoubleWrapper countdw = (DoubleWrapper)aggregation2.get(entry.getKey());
                    value = "" + ((DoubleWrapper)entry.getValue()).d / countdw.d + " " + aggregation3.get(entry.getKey()).d + " " + aggregation4.get(entry.getKey()).d;
                    break;
                }
                case AVG: {
                    DoubleWrapper countdw = (DoubleWrapper)aggregation2.get(entry.getKey());
                    value = "" + ((DoubleWrapper)entry.getValue()).d / countdw.d;
                    break;
                }
                case CUMULATIVE: {
                    value = "" + (cumulative += ((DoubleWrapper)entry.getValue()).d);
                    break;
                }
                default: {
                    value = "" + ((DoubleWrapper)entry.getValue()).d;
                }
            }
            System.out.println(sdf.format(new Date((Long)entry.getKey())) + " " + value);
        }
    }

    private static void increment(long time, HashMap<Long, DoubleWrapper> aggregation, double amount) {
        TimeBinner.get((long)time, aggregation, (double)0.0).d += amount;
    }

    private static void updateMax(long time, HashMap<Long, DoubleWrapper> aggregation, double data, double new_max) {
        DoubleWrapper maxdw = TimeBinner.get(time, aggregation, Double.NEGATIVE_INFINITY);
        if (data > maxdw.d) {
            maxdw.d = new_max;
        }
    }

    private static void updateMin(long time, HashMap<Long, DoubleWrapper> aggregation, double data, double new_min) {
        DoubleWrapper mindw = TimeBinner.get(time, aggregation, Double.POSITIVE_INFINITY);
        if (data < mindw.d) {
            mindw.d = new_min;
        }
    }

    static class Opts
    extends Help {
        @Parameter(names={"--period"}, description="period", converter=ClientOpts.TimeConverter.class, required=true)
        long period = 0L;
        @Parameter(names={"--timeColumn"}, description="time column", required=true)
        int timeColumn = 0;
        @Parameter(names={"--dataColumn"}, description="data column", required=true)
        int dataColumn = 0;
        @Parameter(names={"--operation"}, description="one of: AVG, SUM, MIN, MAX, COUNT", required=true)
        String operation;
        @Parameter(names={"--dateFormat"}, description="a SimpleDataFormat string that describes the data format")
        String dateFormat = "MM/dd/yy-HH:mm:ss";

        Opts() {
        }
    }

    private static class DoubleWrapper {
        double d;

        private DoubleWrapper() {
        }
    }

    static enum Operation {
        AVG,
        SUM,
        MIN,
        MAX,
        COUNT,
        CUMULATIVE,
        AMM,
        AMM_HACK1;

    }
}

