/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import com.google.common.collect.Iterators;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.BatchWriterConfig;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.IteratorSetting;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.client.Scanner;
import org.apache.accumulo.core.client.TableExistsException;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorUtil;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.functional.SlowIterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.Test;

public class ConcurrencyIT
extends AccumuloClusterHarness {
    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        Map siteConfig = cfg.getSiteConfig();
        siteConfig.put(Property.TSERV_MAJC_DELAY.getKey(), "1");
        cfg.setSiteConfig(siteConfig);
    }

    @Override
    protected int defaultTimeoutSeconds() {
        return 120;
    }

    @Test
    public void run() throws Exception {
        Connector c = this.getConnector();
        ConcurrencyIT.runTest(c, this.getUniqueNames(1)[0]);
    }

    static void runTest(Connector c, String tableName) throws AccumuloException, AccumuloSecurityException, TableExistsException, TableNotFoundException, MutationsRejectedException, Exception, InterruptedException {
        c.tableOperations().create(tableName);
        IteratorSetting is = new IteratorSetting(10, SlowIterator.class);
        SlowIterator.setSleepTime(is, 50L);
        c.tableOperations().attachIterator(tableName, is, EnumSet.of(IteratorUtil.IteratorScope.minc, IteratorUtil.IteratorScope.majc));
        c.tableOperations().setProperty(tableName, Property.TABLE_MAJC_RATIO.getKey(), "1.0");
        BatchWriter bw = c.createBatchWriter(tableName, new BatchWriterConfig());
        for (int i = 0; i < 50; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value("foo".getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.flush();
        ScanTask st0 = new ScanTask(c, tableName, 300L);
        st0.start();
        ScanTask st1 = new ScanTask(c, tableName, 100L);
        st1.start();
        UtilWaitThread.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        c.tableOperations().flush(tableName, null, null, true);
        for (int i = 0; i < 50; ++i) {
            Mutation m = new Mutation(new Text(String.format("%06d", i)));
            m.put(new Text("cf1"), new Text("cq1"), new Value("foo".getBytes(StandardCharsets.UTF_8)));
            bw.addMutation(m);
        }
        bw.flush();
        ScanTask st2 = new ScanTask(c, tableName, 100L);
        st2.start();
        st1.join();
        st2.join();
        if (st1.count != 50) {
            throw new Exception("Thread 1 did not see 50, saw " + st1.count);
        }
        if (st2.count != 50) {
            throw new Exception("Thread 2 did not see 50, saw " + st2.count);
        }
        ScanTask st3 = new ScanTask(c, tableName, 150L);
        st3.start();
        UtilWaitThread.sleepUninterruptibly((long)50L, (TimeUnit)TimeUnit.MILLISECONDS);
        c.tableOperations().flush(tableName, null, null, false);
        st3.join();
        if (st3.count != 50) {
            throw new Exception("Thread 3 did not see 50, saw " + st3.count);
        }
        st0.join();
        if (st0.count != 50) {
            throw new Exception("Thread 0 did not see 50, saw " + st0.count);
        }
        bw.close();
    }

    static class ScanTask
    extends Thread {
        int count = 0;
        Scanner scanner;

        ScanTask(Connector conn, String tableName, long time) throws Exception {
            this.scanner = conn.createScanner(tableName, Authorizations.EMPTY);
            IteratorSetting slow = new IteratorSetting(30, "slow", SlowIterator.class);
            SlowIterator.setSleepTime(slow, time);
            this.scanner.addScanIterator(slow);
        }

        @Override
        public void run() {
            this.count = Iterators.size((Iterator)this.scanner.iterator());
        }
    }
}

