/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.functional;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.accumulo.cluster.ClusterControl;
import org.apache.accumulo.cluster.ClusterUser;
import org.apache.accumulo.core.cli.BatchWriterOpts;
import org.apache.accumulo.core.cli.ScannerOpts;
import org.apache.accumulo.core.client.ClientConfiguration;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.KerberosToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.zookeeper.ZooUtil;
import org.apache.accumulo.fate.util.UtilWaitThread;
import org.apache.accumulo.fate.zookeeper.ZooCache;
import org.apache.accumulo.fate.zookeeper.ZooLock;
import org.apache.accumulo.fate.zookeeper.ZooReader;
import org.apache.accumulo.harness.AccumuloClusterHarness;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.test.TestIngest;
import org.apache.accumulo.test.VerifyIngest;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestartIT
extends AccumuloClusterHarness {
    private static final Logger log = LoggerFactory.getLogger(RestartIT.class);
    private static final ScannerOpts SOPTS = new ScannerOpts();
    private static final VerifyIngest.Opts VOPTS = new VerifyIngest.Opts();
    private static final TestIngest.Opts OPTS = new TestIngest.Opts();
    private static final BatchWriterOpts BWOPTS = new BatchWriterOpts();
    private ExecutorService svc;

    @Override
    public int defaultTimeoutSeconds() {
        return 600;
    }

    @Override
    public void configureMiniCluster(MiniAccumuloConfigImpl cfg, Configuration hadoopCoreSite) {
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "15s");
        cfg.setProperty(Property.GC_CYCLE_DELAY, "1s");
        cfg.setProperty(Property.GC_CYCLE_START, "1s");
        hadoopCoreSite.set("fs.file.impl", RawLocalFileSystem.class.getName());
    }

    @Before
    public void setup() throws Exception {
        this.svc = Executors.newFixedThreadPool(1);
    }

    @After
    public void teardown() throws Exception {
        if (null == this.svc) {
            return;
        }
        if (!this.svc.isShutdown()) {
            this.svc.shutdown();
        }
        while (!this.svc.awaitTermination(10L, TimeUnit.SECONDS)) {
            log.info("Waiting for threadpool to terminate");
        }
    }

    @Test
    public void restartMaster() throws Exception {
        String[] args;
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        OPTS.setTableName(tableName);
        VOPTS.setTableName(tableName);
        c.tableOperations().create(tableName);
        AuthenticationToken token = RestartIT.getAdminToken();
        final ClusterControl control = RestartIT.getCluster().getClusterControl();
        if (token instanceof PasswordToken) {
            byte[] password = ((PasswordToken)token).getPassword();
            args = new String[]{"-u", RestartIT.getAdminPrincipal(), "-p", new String(password, StandardCharsets.UTF_8), "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--rows", "" + RestartIT.OPTS.rows, "--table", tableName};
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
            VOPTS.setPrincipal(RestartIT.getAdminPrincipal());
        } else if (token instanceof KerberosToken) {
            ClusterUser rootUser = this.getAdminUser();
            args = new String[]{"-u", RestartIT.getAdminPrincipal(), "--keytab", rootUser.getKeytab().getAbsolutePath(), "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--rows", "" + RestartIT.OPTS.rows, "--table", tableName};
            ClientConfiguration clientConfig = cluster.getClientConfig();
            OPTS.updateKerberosCredentials(clientConfig);
            VOPTS.updateKerberosCredentials(clientConfig);
        } else {
            throw new RuntimeException("Unknown token");
        }
        Future<Integer> ret = this.svc.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    return control.exec(TestIngest.class, args);
                }
                catch (IOException e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            }
        });
        control.stopAllServers(ServerType.MASTER);
        control.startAllServers(ServerType.MASTER);
        Assert.assertEquals((long)0L, (long)ret.get().intValue());
        VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
    }

    @Test
    public void restartMasterRecovery() throws Exception {
        byte[] masterLockData;
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        OPTS.setTableName(tableName);
        VOPTS.setTableName(tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            OPTS.updateKerberosCredentials(clientConfig);
            VOPTS.updateKerberosCredentials(clientConfig);
        } else {
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
            VOPTS.setPrincipal(RestartIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, OPTS, BWOPTS);
        ClusterControl control = RestartIT.getCluster().getClusterControl();
        control.stopAllServers(ServerType.MASTER);
        control.stopAllServers(ServerType.TRACER);
        control.stopAllServers(ServerType.TABLET_SERVER);
        control.stopAllServers(ServerType.GARBAGE_COLLECTOR);
        control.stopAllServers(ServerType.MONITOR);
        ZooReader zreader = new ZooReader(c.getInstance().getZooKeepers(), c.getInstance().getZooKeepersSessionTimeOut());
        ZooCache zcache = new ZooCache(zreader, null);
        do {
            if (null == (masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((Instance)c.getInstance()) + "/masters/lock"), null))) continue;
            log.info("Master lock is still held");
            Thread.sleep(1000L);
        } while (null != masterLockData);
        cluster.start();
        UtilWaitThread.sleepUninterruptibly((long)5L, (TimeUnit)TimeUnit.MILLISECONDS);
        control.stopAllServers(ServerType.MASTER);
        masterLockData = new byte[]{};
        do {
            if (null == (masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((Instance)c.getInstance()) + "/masters/lock"), null))) continue;
            log.info("Master lock is still held");
            Thread.sleep(1000L);
        } while (null != masterLockData);
        cluster.start();
        VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
    }

    @Test
    public void restartMasterSplit() throws Exception {
        byte[] masterLockData;
        String[] args;
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        AuthenticationToken token = RestartIT.getAdminToken();
        final ClusterControl control = RestartIT.getCluster().getClusterControl();
        VOPTS.setTableName(tableName);
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "5K");
        if (token instanceof PasswordToken) {
            byte[] password = ((PasswordToken)token).getPassword();
            args = new String[]{"-u", RestartIT.getAdminPrincipal(), "-p", new String(password, StandardCharsets.UTF_8), "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--rows", Integer.toString(RestartIT.VOPTS.rows), "--table", tableName};
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
            VOPTS.setPrincipal(RestartIT.getAdminPrincipal());
        } else if (token instanceof KerberosToken) {
            ClusterUser rootUser = this.getAdminUser();
            args = new String[]{"-u", RestartIT.getAdminPrincipal(), "--keytab", rootUser.getKeytab().getAbsolutePath(), "-i", cluster.getInstanceName(), "-z", cluster.getZooKeepers(), "--rows", Integer.toString(RestartIT.VOPTS.rows), "--table", tableName};
            ClientConfiguration clientConfig = cluster.getClientConfig();
            OPTS.updateKerberosCredentials(clientConfig);
            VOPTS.updateKerberosCredentials(clientConfig);
        } else {
            throw new RuntimeException("Unknown token");
        }
        Future<Integer> ret = this.svc.submit(new Callable<Integer>(){

            @Override
            public Integer call() {
                try {
                    return control.exec(TestIngest.class, args);
                }
                catch (Exception e) {
                    log.error("Error running TestIngest", (Throwable)e);
                    return -1;
                }
            }
        });
        control.stopAllServers(ServerType.MASTER);
        ZooReader zreader = new ZooReader(c.getInstance().getZooKeepers(), c.getInstance().getZooKeepersSessionTimeOut());
        ZooCache zcache = new ZooCache(zreader, null);
        do {
            if (null == (masterLockData = ZooLock.getLockData((ZooCache)zcache, (String)(ZooUtil.getRoot((Instance)c.getInstance()) + "/masters/lock"), null))) continue;
            log.info("Master lock is still held");
            Thread.sleep(1000L);
        } while (null != masterLockData);
        cluster.start();
        Assert.assertEquals((long)0L, (long)ret.get().intValue());
        VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
    }

    @Test
    public void killedTabletServer() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        OPTS.setTableName(tableName);
        VOPTS.setTableName(tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            OPTS.updateKerberosCredentials(clientConfig);
            VOPTS.updateKerberosCredentials(clientConfig);
        } else {
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
            VOPTS.setPrincipal(RestartIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, OPTS, BWOPTS);
        VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
        cluster.getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
        cluster.start();
        VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
    }

    @Test
    public void killedTabletServer2() throws Exception {
        Connector c = this.getConnector();
        String[] names = this.getUniqueNames(2);
        String tableName = names[0];
        ClusterControl control = RestartIT.getCluster().getClusterControl();
        c.tableOperations().create(tableName);
        control.stopAllServers(ServerType.TABLET_SERVER);
        cluster.start();
        c.tableOperations().create(names[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void killedTabletServerDuringShutdown() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        c.tableOperations().create(tableName);
        OPTS.setTableName(tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            OPTS.updateKerberosCredentials(clientConfig);
        } else {
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
        }
        TestIngest.ingest(c, OPTS, BWOPTS);
        try {
            RestartIT.getCluster().getClusterControl().stopAllServers(ServerType.TABLET_SERVER);
            RestartIT.getCluster().getClusterControl().adminStopAll();
        }
        finally {
            RestartIT.getCluster().start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shutdownDuringCompactingSplitting() throws Exception {
        Connector c = this.getConnector();
        String tableName = this.getUniqueNames(1)[0];
        VOPTS.setTableName(tableName);
        ClientConfiguration clientConfig = cluster.getClientConfig();
        if (clientConfig.hasSasl()) {
            OPTS.updateKerberosCredentials(clientConfig);
            VOPTS.updateKerberosCredentials(clientConfig);
        } else {
            OPTS.setPrincipal(RestartIT.getAdminPrincipal());
            VOPTS.setPrincipal(RestartIT.getAdminPrincipal());
        }
        c.tableOperations().create(tableName);
        c.tableOperations().setProperty(tableName, Property.TABLE_SPLIT_THRESHOLD.getKey(), "10K");
        String splitThreshold = null;
        for (Map.Entry entry : c.tableOperations().getProperties(tableName)) {
            if (!((String)entry.getKey()).equals(Property.TABLE_SPLIT_THRESHOLD.getKey())) continue;
            splitThreshold = (String)entry.getValue();
            break;
        }
        Assert.assertNotNull(splitThreshold);
        try {
            c.tableOperations().setProperty("accumulo.metadata", Property.TABLE_SPLIT_THRESHOLD.getKey(), "20K");
            TestIngest.Opts opts = new TestIngest.Opts();
            opts.setTableName(tableName);
            if (clientConfig.hasSasl()) {
                opts.updateKerberosCredentials(clientConfig);
            } else {
                opts.setPrincipal(RestartIT.getAdminPrincipal());
            }
            TestIngest.ingest(c, opts, BWOPTS);
            c.tableOperations().flush(tableName, null, null, false);
            VerifyIngest.verifyIngest(c, VOPTS, SOPTS);
            RestartIT.getCluster().stop();
        }
        finally {
            if (RestartIT.getClusterType() == AccumuloClusterHarness.ClusterType.STANDALONE) {
                RestartIT.getCluster().start();
                c.tableOperations().setProperty("accumulo.metadata", Property.TABLE_SPLIT_THRESHOLD.getKey(), splitThreshold);
            }
        }
    }

    static {
        RestartIT.VOPTS.rows = 10000;
        RestartIT.OPTS.rows = 10000;
    }
}

