/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.master;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.Instance;
import org.apache.accumulo.core.client.ZooKeeperInstance;
import org.apache.accumulo.core.client.impl.ClientContext;
import org.apache.accumulo.core.client.impl.ClientExec;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.impl.MasterClient;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.thrift.MasterClientService;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.minicluster.ServerType;
import org.apache.accumulo.minicluster.impl.MiniAccumuloConfigImpl;
import org.apache.accumulo.minicluster.impl.ProcessReference;
import org.apache.accumulo.server.master.state.MetaDataTableScanner;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletLocationState;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuspendedTabletsIT
extends ConfigurableMacBase {
    private static final Logger log = LoggerFactory.getLogger(SuspendedTabletsIT.class);
    private static final Random RANDOM = new Random();
    private static ExecutorService THREAD_POOL;
    public static final int TSERVERS = 5;
    public static final long SUSPEND_DURATION;
    public static final int TABLETS = 100;
    private static final AtomicInteger threadCounter;

    @Override
    protected int defaultTimeoutSeconds() {
        return 300;
    }

    @Override
    public void configure(MiniAccumuloConfigImpl cfg, Configuration fsConf) {
        cfg.setProperty(Property.TABLE_SUSPEND_DURATION, SUSPEND_DURATION + "ms");
        cfg.setProperty(Property.INSTANCE_ZK_TIMEOUT, "5s");
        cfg.setNumTservers(5);
    }

    private boolean isAlive(Process p) {
        try {
            p.exitValue();
            return false;
        }
        catch (IllegalThreadStateException e) {
            return true;
        }
    }

    @Test
    public void crashAndResumeTserver() throws Exception {
        this.suspensionTestBody(new TServerKiller(){

            @Override
            public void eliminateTabletServers(ClientContext ctx, TabletLocations locs, int count) throws Exception {
                ArrayList procs = new ArrayList((Collection)SuspendedTabletsIT.this.getCluster().getProcesses().get(ServerType.TABLET_SERVER));
                Collections.shuffle(procs);
                for (int i = 0; i < count; ++i) {
                    ProcessReference pr = (ProcessReference)procs.get(i);
                    log.info("Crashing {}", (Object)pr.getProcess());
                    SuspendedTabletsIT.this.getCluster().killProcess(ServerType.TABLET_SERVER, pr);
                }
            }
        });
    }

    @Test
    public void shutdownAndResumeTserver() throws Exception {
        this.suspensionTestBody(new TServerKiller(){

            @Override
            public void eliminateTabletServers(final ClientContext ctx, TabletLocations locs, int count) throws Exception {
                int i;
                HashSet<TServerInstance> tserversSet = new HashSet<TServerInstance>();
                for (TabletLocationState tls : locs.locationStates.values()) {
                    if (tls.current == null) continue;
                    tserversSet.add(tls.current);
                }
                ArrayList tserversList = new ArrayList(tserversSet);
                Collections.shuffle(tserversList, RANDOM);
                for (i = 0; i < count; ++i) {
                    final String tserverName = ((TServerInstance)tserversList.get(i)).toString();
                    MasterClient.executeVoid((ClientContext)ctx, (ClientExec)new ClientExec<MasterClientService.Client>(){

                        public void execute(MasterClientService.Client client) throws Exception {
                            log.info("Sending shutdown command to {} via MasterClientService", (Object)tserverName);
                            client.shutdownTabletServer(null, ctx.rpcCreds(), tserverName, false);
                        }
                    });
                }
                log.info("Waiting for tserver process{} to die", (Object)(count == 1 ? "" : "es"));
                for (i = 0; i < 10; ++i) {
                    ArrayList<ProcessReference> deadProcs = new ArrayList<ProcessReference>();
                    for (ProcessReference pr : (Collection)SuspendedTabletsIT.this.getCluster().getProcesses().get(ServerType.TABLET_SERVER)) {
                        Process p = pr.getProcess();
                        if (SuspendedTabletsIT.this.isAlive(p)) continue;
                        deadProcs.add(pr);
                    }
                    for (ProcessReference pr : deadProcs) {
                        log.info("Process {} is dead, informing cluster control about this", (Object)pr.getProcess());
                        SuspendedTabletsIT.this.getCluster().getClusterControl().killProcess(ServerType.TABLET_SERVER, pr);
                        --count;
                    }
                    if (count == 0) {
                        return;
                    }
                    Thread.sleep(TimeUnit.MILLISECONDS.convert(2L, TimeUnit.SECONDS));
                }
                throw new IllegalStateException("Tablet servers didn't die!");
            }
        });
    }

    private void suspensionTestBody(TServerKiller serverStopper) throws Exception {
        Credentials creds = new Credentials("root", (AuthenticationToken)new PasswordToken((CharSequence)"testRootPassword1"));
        ZooKeeperInstance instance = new ZooKeeperInstance(this.getCluster().getClientConfig());
        ClientContext ctx = new ClientContext((Instance)instance, creds, this.getCluster().getClientConfig());
        String tableName = this.getUniqueNames(1)[0];
        Connector conn = ctx.getConnector();
        log.info("Creating table " + tableName);
        conn.tableOperations().create(tableName);
        TreeSet<Text> splitPoints = new TreeSet<Text>();
        for (int i = 1; i < 100; ++i) {
            splitPoints.add(new Text("" + i));
        }
        conn.tableOperations().addSplits(tableName, splitPoints);
        log.info("Waiting on hosting and balance");
        TabletLocations ds = TabletLocations.retrieve(ctx, tableName);
        while (ds.hostedCount != 100) {
            Thread.sleep(1000L);
            ds = TabletLocations.retrieve(ctx, tableName);
        }
        conn.instanceOperations().waitForBalance();
        do {
            Thread.sleep(5000L);
            ds = TabletLocations.retrieve(ctx, tableName);
        } while (ds.hostedCount != 100);
        Assert.assertEquals((long)5L, (long)ds.hosted.keySet().size());
        TabletLocations beforeDeathState = ds;
        log.info("Eliminating tablet servers");
        serverStopper.eliminateTabletServers(ctx, beforeDeathState, 2);
        log.info("Waiting on suspended tablets");
        ds = TabletLocations.retrieve(ctx, tableName);
        long killTime = System.nanoTime();
        while (ds.suspended.keySet().size() != 2) {
            Thread.sleep(1000L);
            ds = TabletLocations.retrieve(ctx, tableName);
        }
        SetMultimap<HostAndPort, KeyExtent> deadTabletsByServer = ds.suspended;
        for (HostAndPort server : deadTabletsByServer.keySet()) {
            Assert.assertEquals((Object)deadTabletsByServer.get((Object)server), (Object)beforeDeathState.hosted.get((Object)server));
        }
        Assert.assertEquals((long)100L, (long)(ds.hostedCount + ds.suspendedCount));
        HostAndPort restartedServer = (HostAndPort)deadTabletsByServer.keySet().iterator().next();
        log.info("Restarting " + restartedServer);
        this.getCluster().getClusterControl().start(ServerType.TABLET_SERVER, null, (Map)ImmutableMap.of((Object)Property.TSERV_CLIENTPORT.getKey(), (Object)("" + restartedServer.getPort()), (Object)Property.TSERV_PORTSEARCH.getKey(), (Object)"false"), 1);
        log.info("Awaiting tablet unsuspension for tablets belonging to " + restartedServer);
        ds = TabletLocations.retrieve(ctx, tableName);
        while (ds.suspended.containsKey((Object)restartedServer) || ds.assignedCount != 0) {
            Thread.sleep(1000L);
            ds = TabletLocations.retrieve(ctx, tableName);
        }
        Assert.assertEquals((Object)deadTabletsByServer.get((Object)restartedServer), (Object)ds.hosted.get((Object)restartedServer));
        log.info("Awaiting tablet reassignment for remaining tablets");
        ds = TabletLocations.retrieve(ctx, tableName);
        while (ds.hostedCount != 100) {
            Thread.sleep(1000L);
            ds = TabletLocations.retrieve(ctx, tableName);
        }
        long recoverTime = System.nanoTime();
        Assert.assertTrue((recoverTime - killTime >= TimeUnit.NANOSECONDS.convert(SUSPEND_DURATION, TimeUnit.MILLISECONDS) ? 1 : 0) != 0);
    }

    @BeforeClass
    public static void init() {
        THREAD_POOL = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "Scanning deadline thread #" + threadCounter.incrementAndGet());
            }
        });
    }

    @AfterClass
    public static void cleanup() {
        THREAD_POOL.shutdownNow();
    }

    static {
        SUSPEND_DURATION = TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS);
        threadCounter = new AtomicInteger(0);
    }

    private static class TabletLocations {
        public final Map<KeyExtent, TabletLocationState> locationStates = new HashMap<KeyExtent, TabletLocationState>();
        public final SetMultimap<HostAndPort, KeyExtent> hosted = HashMultimap.create();
        public final SetMultimap<HostAndPort, KeyExtent> suspended = HashMultimap.create();
        public int hostedCount = 0;
        public int assignedCount = 0;
        public int suspendedCount = 0;

        private TabletLocations() {
        }

        public static TabletLocations retrieve(final ClientContext ctx, final String tableName) throws Exception {
            int sleepTime = 200;
            int remainingAttempts = 30;
            while (true) {
                try {
                    FutureTask<TabletLocations> tlsFuture = new FutureTask<TabletLocations>(new Callable<TabletLocations>(){

                        @Override
                        public TabletLocations call() throws Exception {
                            TabletLocations answer = new TabletLocations();
                            answer.scan(ctx, tableName);
                            return answer;
                        }
                    });
                    THREAD_POOL.submit(tlsFuture);
                    return tlsFuture.get(5L, TimeUnit.SECONDS);
                }
                catch (TimeoutException ex) {
                    log.debug("Retrieval timed out", (Throwable)ex);
                }
                catch (Exception ex) {
                    log.warn("Failed to scan metadata", (Throwable)ex);
                }
                sleepTime = Math.min(2 * sleepTime, 10000);
                Thread.sleep(sleepTime);
                if (--remainingAttempts != 0) continue;
                Assert.fail((String)"Scanning of metadata failed, aborting");
            }
        }

        private void scan(ClientContext ctx, String tableName) throws Exception {
            Map idMap = ctx.getConnector().tableOperations().tableIdMap();
            String tableId = Objects.requireNonNull((String)idMap.get(tableName));
            try (MetaDataTableScanner scanner = new MetaDataTableScanner(ctx, new Range());){
                while (scanner.hasNext()) {
                    TabletLocationState tls = scanner.next();
                    if (!tls.extent.getTableId().equals(tableId)) continue;
                    this.locationStates.put(tls.extent, tls);
                    if (tls.suspend != null) {
                        this.suspended.put((Object)tls.suspend.server, (Object)tls.extent);
                        ++this.suspendedCount;
                        continue;
                    }
                    if (tls.current != null) {
                        this.hosted.put((Object)tls.current.getLocation(), (Object)tls.extent);
                        ++this.hostedCount;
                        continue;
                    }
                    if (tls.future == null) continue;
                    ++this.assignedCount;
                }
            }
        }
    }

    private static interface TServerKiller {
        public void eliminateTabletServers(ClientContext var1, TabletLocations var2, int var3) throws Exception;
    }
}

