/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.randomwalk.security;

import java.util.Arrays;
import java.util.Properties;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.client.impl.Credentials;
import org.apache.accumulo.core.client.security.tokens.AuthenticationToken;
import org.apache.accumulo.core.client.security.tokens.PasswordToken;
import org.apache.accumulo.test.randomwalk.Environment;
import org.apache.accumulo.test.randomwalk.State;
import org.apache.accumulo.test.randomwalk.Test;
import org.apache.accumulo.test.randomwalk.security.WalkingSecurity;

public class Authenticate
extends Test {
    @Override
    public void visit(State state, Environment env, Properties props) throws Exception {
        Authenticate.authenticate(WalkingSecurity.get(state, env).getSysUserName(), WalkingSecurity.get(state, env).getSysToken(), state, env, props);
    }

    public static void authenticate(String principal, AuthenticationToken token, State state, Environment env, Properties props) throws Exception {
        boolean result;
        String targetProp = props.getProperty("target");
        boolean success = Boolean.parseBoolean(props.getProperty("valid"));
        Connector conn = env.getInstance().getConnector(principal, token);
        String target = targetProp.equals("table") ? WalkingSecurity.get(state, env).getTabUserName() : WalkingSecurity.get(state, env).getSysUserName();
        boolean exists = WalkingSecurity.get(state, env).userExists(target);
        byte[] password = Arrays.copyOf(WalkingSecurity.get(state, env).getUserPassword(target), WalkingSecurity.get(state, env).getUserPassword(target).length);
        boolean hasPermission = WalkingSecurity.get(state, env).canAskAboutUser(new Credentials(principal, token).toThrift(env.getInstance()), target);
        if (!success) {
            int i = 0;
            while (i < password.length) {
                int n = i++;
                password[n] = (byte)(password[n] + 1);
            }
        }
        try {
            result = conn.securityOperations().authenticateUser(target, (AuthenticationToken)new PasswordToken(password));
        }
        catch (AccumuloSecurityException ae) {
            switch (ae.getSecurityErrorCode()) {
                case PERMISSION_DENIED: {
                    if (exists && hasPermission) {
                        throw new AccumuloException("Got a security exception when I should have had permission.", (Throwable)ae);
                    }
                    return;
                }
            }
            throw new AccumuloException("Unexpected exception!", (Throwable)ae);
        }
        if (!hasPermission) {
            throw new AccumuloException("Didn't get Security Exception when we should have");
        }
        if (result != (success && exists)) {
            throw new AccumuloException("Authentication " + (result ? "succeeded" : "failed") + " when it should have " + (success && exists ? "succeeded" : "failed") + " while the user exists? " + exists);
        }
    }
}

