/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.test.replication;

import com.google.protobuf.GeneratedMessage;
import java.util.HashMap;
import java.util.Map;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.protobuf.ProtobufUtil;
import org.apache.accumulo.core.replication.ReplicationSchema;
import org.apache.accumulo.core.replication.ReplicationTable;
import org.apache.accumulo.core.replication.ReplicationTarget;
import org.apache.accumulo.core.security.TablePermission;
import org.apache.accumulo.master.replication.SequentialWorkAssigner;
import org.apache.accumulo.server.replication.DistributedWorkQueueWorkAssignerHelper;
import org.apache.accumulo.server.replication.proto.Replication;
import org.apache.accumulo.server.zookeeper.DistributedWorkQueue;
import org.apache.accumulo.server.zookeeper.ZooCache;
import org.apache.accumulo.test.functional.ConfigurableMacBase;
import org.apache.hadoop.io.Text;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Replication ITs are not stable and not currently maintained")
public class SequentialWorkAssignerIT
extends ConfigurableMacBase {
    private Connector conn;
    private MockSequentialWorkAssigner assigner;

    @Before
    public void init() throws Exception {
        this.conn = this.getConnector();
        this.assigner = new MockSequentialWorkAssigner(this.conn);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.READ);
        this.conn.securityOperations().grantTablePermission(this.conn.whoami(), "accumulo.replication", TablePermission.WRITE);
        ReplicationTable.setOnline((Connector)this.conn);
    }

    @Test
    public void createWorkForFilesInCorrectOrder() throws Exception {
        ReplicationTarget target = new ReplicationTarget("cluster1", "table1", "1");
        Text serializedTarget = target.toText();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        String filename1 = "z_file1";
        String filename2 = "a_file1";
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(250L).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(500L).build();
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget, (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget, (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file1, (long)stat1.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file2, (long)stat2.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashMap<String, Map<String, String>> queuedWork = new HashMap<String, Map<String, String>>();
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target), file1);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
        Assert.assertEquals((long)1L, (long)queuedWork.size());
        Assert.assertTrue((boolean)queuedWork.containsKey("cluster1"));
        Map cluster1Work = (Map)queuedWork.get("cluster1");
        Assert.assertEquals((long)1L, (long)cluster1Work.size());
        Assert.assertTrue((boolean)cluster1Work.containsKey(target.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target), cluster1Work.get(target.getSourceTableId()));
    }

    @Test
    public void workAcrossTablesHappensConcurrently() throws Exception {
        ReplicationTarget target1 = new ReplicationTarget("cluster1", "table1", "1");
        Text serializedTarget1 = target1.toText();
        ReplicationTarget target2 = new ReplicationTarget("cluster1", "table2", "2");
        Text serializedTarget2 = target2.toText();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        String filename1 = "z_file1";
        String filename2 = "a_file1";
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(250L).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(500L).build();
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget1, (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget2, (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file1, (long)stat1.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target1.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file2, (long)stat2.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target2.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashMap<String, Map<String, String>> queuedWork = new HashMap<String, Map<String, String>>();
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target1), file1);
        EasyMock.expectLastCall().once();
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target2), file2);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
        Assert.assertEquals((long)1L, (long)queuedWork.size());
        Assert.assertTrue((boolean)queuedWork.containsKey("cluster1"));
        Map cluster1Work = (Map)queuedWork.get("cluster1");
        Assert.assertEquals((long)2L, (long)cluster1Work.size());
        Assert.assertTrue((boolean)cluster1Work.containsKey(target1.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target1), cluster1Work.get(target1.getSourceTableId()));
        Assert.assertTrue((boolean)cluster1Work.containsKey(target2.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target2), cluster1Work.get(target2.getSourceTableId()));
    }

    @Test
    public void workAcrossPeersHappensConcurrently() throws Exception {
        ReplicationTarget target1 = new ReplicationTarget("cluster1", "table1", "1");
        Text serializedTarget1 = target1.toText();
        ReplicationTarget target2 = new ReplicationTarget("cluster2", "table1", "1");
        Text serializedTarget2 = target2.toText();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        String filename1 = "z_file1";
        String filename2 = "a_file1";
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(250L).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(500L).build();
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget1, (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget2, (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file1, (long)stat1.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target1.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file2, (long)stat2.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target2.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashMap<String, Map<String, String>> queuedWork = new HashMap<String, Map<String, String>>();
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target1), file1);
        EasyMock.expectLastCall().once();
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target2), file2);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
        Assert.assertEquals((long)2L, (long)queuedWork.size());
        Assert.assertTrue((boolean)queuedWork.containsKey("cluster1"));
        Map cluster1Work = (Map)queuedWork.get("cluster1");
        Assert.assertEquals((long)1L, (long)cluster1Work.size());
        Assert.assertTrue((boolean)cluster1Work.containsKey(target1.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target1), cluster1Work.get(target1.getSourceTableId()));
        Map cluster2Work = (Map)queuedWork.get("cluster2");
        Assert.assertEquals((long)1L, (long)cluster2Work.size());
        Assert.assertTrue((boolean)cluster2Work.containsKey(target2.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target2), cluster2Work.get(target2.getSourceTableId()));
    }

    @Test
    public void reprocessingOfCompletedWorkRemovesWork() throws Exception {
        ReplicationTarget target = new ReplicationTarget("cluster1", "table1", "1");
        Text serializedTarget = target.toText();
        BatchWriter bw = ReplicationTable.getBatchWriter((Connector)this.conn);
        String filename1 = "z_file1";
        String filename2 = "a_file1";
        String file1 = "/accumulo/wal/tserver+port/" + filename1;
        String file2 = "/accumulo/wal/tserver+port/" + filename2;
        Replication.Status stat1 = Replication.Status.newBuilder().setBegin(100L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(250L).build();
        Replication.Status stat2 = Replication.Status.newBuilder().setBegin(0L).setEnd(100L).setClosed(true).setInfiniteEnd(false).setCreatedTime(500L).build();
        Mutation m = new Mutation((CharSequence)file1);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget, (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = new Mutation((CharSequence)file2);
        ReplicationSchema.WorkSection.add((Mutation)m, (Text)serializedTarget, (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file1, (long)stat1.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat1));
        bw.addMutation(m);
        m = ReplicationSchema.OrderSection.createMutation((String)file2, (long)stat2.getCreatedTime());
        ReplicationSchema.OrderSection.add((Mutation)m, (String)target.getSourceTableId(), (Value)ProtobufUtil.toValue((GeneratedMessage)stat2));
        bw.addMutation(m);
        bw.close();
        DistributedWorkQueue workQueue = (DistributedWorkQueue)EasyMock.createMock(DistributedWorkQueue.class);
        HashMap<String, Map<String, String>> queuedWork = new HashMap<String, Map<String, String>>();
        HashMap<String, String> queuedWorkForCluster = new HashMap<String, String>();
        queuedWorkForCluster.put(target.getSourceTableId(), DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename1, (ReplicationTarget)target));
        queuedWork.put("cluster1", queuedWorkForCluster);
        this.assigner.setQueuedWork(queuedWork);
        this.assigner.setWorkQueue(workQueue);
        this.assigner.setMaxQueueSize(Integer.MAX_VALUE);
        workQueue.addWork(DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target), file2);
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{workQueue});
        this.assigner.createWork();
        EasyMock.verify((Object[])new Object[]{workQueue});
        Assert.assertEquals((long)1L, (long)queuedWork.size());
        Assert.assertTrue((boolean)queuedWork.containsKey("cluster1"));
        Map cluster1Work = (Map)queuedWork.get("cluster1");
        Assert.assertEquals((long)1L, (long)cluster1Work.size());
        Assert.assertTrue((boolean)cluster1Work.containsKey(target.getSourceTableId()));
        Assert.assertEquals((Object)DistributedWorkQueueWorkAssignerHelper.getQueueKey((String)filename2, (ReplicationTarget)target), cluster1Work.get(target.getSourceTableId()));
    }

    private static class MockSequentialWorkAssigner
    extends SequentialWorkAssigner {
        public MockSequentialWorkAssigner(Connector conn) {
            super(null, conn);
        }

        public void setConnector(Connector conn) {
            super.setConnector(conn);
        }

        public void setQueuedWork(Map<String, Map<String, String>> queuedWork) {
            super.setQueuedWork(queuedWork);
        }

        public void setWorkQueue(DistributedWorkQueue workQueue) {
            super.setWorkQueue(workQueue);
        }

        public void setMaxQueueSize(int maxQueueSize) {
            super.setMaxQueueSize(maxQueueSize);
        }

        public void createWork() {
            super.createWork();
        }

        public void setZooCache(ZooCache zooCache) {
            super.setZooCache(zooCache);
        }

        public void cleanupFinishedWork() {
            super.cleanupFinishedWork();
        }
    }
}

