/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.tserver.metrics;

import javax.management.ObjectName;
import org.apache.accumulo.server.metrics.AbstractMetricsImpl;
import org.apache.accumulo.tserver.metrics.TabletServerScanMetricsMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabletServerScanMetrics
extends AbstractMetricsImpl
implements TabletServerScanMetricsMBean {
    static final Logger log = LoggerFactory.getLogger(TabletServerScanMetrics.class);
    public static final String METRICS_PREFIX = "tserver.scan";
    ObjectName OBJECT_NAME = null;

    TabletServerScanMetrics() {
        this.reset();
        try {
            this.OBJECT_NAME = new ObjectName("accumulo.server.metrics:service=TServerInfo,name=TabletServerScanMetricsMBean,instance=" + Thread.currentThread().getName());
        }
        catch (Exception e) {
            log.error("Exception setting MBean object name", (Throwable)e);
        }
    }

    protected ObjectName getObjectName() {
        return this.OBJECT_NAME;
    }

    protected String getMetricsPrefix() {
        return METRICS_PREFIX;
    }

    @Override
    public long getResultAvgSize() {
        return this.getMetricAvg("result");
    }

    @Override
    public long getResultCount() {
        return this.getMetricCount("result");
    }

    @Override
    public long getResultMaxSize() {
        return this.getMetricMax("result");
    }

    @Override
    public long getResultMinSize() {
        return this.getMetricMin("result");
    }

    @Override
    public long getScanAvgTime() {
        return this.getMetricAvg("scan");
    }

    @Override
    public long getScanCount() {
        return this.getMetricCount("scan");
    }

    @Override
    public long getScanMaxTime() {
        return this.getMetricMax("scan");
    }

    @Override
    public long getScanMinTime() {
        return this.getMetricMin("scan");
    }

    @Override
    public void reset() {
        this.createMetric("scan");
        this.createMetric("result");
    }
}

