/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rahas.impl;

import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.rahas.RahasData;
import org.apache.rahas.Token;
import org.apache.rahas.TokenIssuer;
import org.apache.rahas.TrustException;
import org.apache.rahas.TrustUtil;
import org.apache.rahas.impl.SAMLTokenIssuerConfig;
import org.apache.rahas.impl.TokenIssuerUtil;
import org.apache.rahas.impl.util.CommonUtil;
import org.apache.rahas.impl.util.SAML2Utils;
import org.apache.rahas.impl.util.SAMLAttributeCallback;
import org.apache.rahas.impl.util.SAMLCallbackHandler;
import org.apache.rahas.impl.util.SignKeyHolder;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.utils.Base64;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLException;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.AttributeStatement;
import org.opensaml.saml2.core.AttributeValue;
import org.opensaml.saml2.core.AuthnContext;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnStatement;
import org.opensaml.saml2.core.Conditions;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.KeyInfoConfirmationDataType;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.Subject;
import org.opensaml.saml2.core.SubjectConfirmation;
import org.opensaml.saml2.core.SubjectConfirmationData;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSStringBuilder;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.SignatureException;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Certificate;
import org.opensaml.xml.signature.X509Data;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SAML2TokenIssuer
implements TokenIssuer {
    private String configParamName;
    private OMElement configElement;
    private String configFile;
    protected List<Signature> signatureList = new ArrayList<Signature>();
    private boolean isSymmetricKeyBasedHoK = false;
    private SAMLTokenIssuerConfig tokenIssuerConfiguration;
    private static Log log = LogFactory.getLog(SAML2TokenIssuer.class);

    public SOAPEnvelope issue(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        this.tokenIssuerConfiguration = CommonUtil.getTokenIssuerConfiguration(this.configElement, this.configFile, inMsgCtx.getParameter(this.configParamName));
        if (this.tokenIssuerConfiguration == null) {
            if (log.isDebugEnabled()) {
                String parameterName = this.configElement != null ? "OMElement - " + this.configElement.toString() : (this.configFile != null ? "File - " + this.configFile : (this.configParamName != null ? "With message context parameter name - " + this.configParamName : "No method to build configurations"));
                log.debug((Object)("Unable to build token configurations, " + parameterName));
            }
            throw new TrustException("configurationIsNull");
        }
        SOAPEnvelope env = TrustUtil.createSOAPEnvelope(inMsgCtx.getEnvelope().getNamespace().getNamespaceURI());
        Crypto crypto = this.tokenIssuerConfiguration.getIssuerCrypto(inMsgCtx.getAxisService().getClassLoader());
        Document doc = ((Element)env).getOwnerDocument();
        int keySize = data.getKeySize();
        keySize = keySize == -1 ? this.tokenIssuerConfiguration.getKeySize() : keySize;
        data.setKeySize(keySize);
        Assertion assertion = this.buildAssertion(doc, crypto, data);
        Assertion signedAssertion = this.signAssertion(doc, assertion, crypto);
        return this.createRequestSecurityTokenResponse(data, signedAssertion, env);
    }

    protected SOAPEnvelope createRequestSecurityTokenResponse(RahasData rahasData, Assertion assertion, SOAPEnvelope soapEnvelope) throws TrustException {
        OMElement requestSecurityTokenResponse;
        int wstVersion = rahasData.getVersion();
        if (1 == wstVersion) {
            requestSecurityTokenResponse = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, (OMElement)soapEnvelope.getBody());
        } else {
            OMElement requestSecurityTokenResponseCollectionElement = TrustUtil.createRequestSecurityTokenResponseCollectionElement(wstVersion, (OMElement)soapEnvelope.getBody());
            requestSecurityTokenResponse = TrustUtil.createRequestSecurityTokenResponseElement(wstVersion, requestSecurityTokenResponseCollectionElement);
        }
        TrustUtil.createTokenTypeElement(wstVersion, requestSecurityTokenResponse).setText("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        if (rahasData.getKeyType().endsWith("/SymmetricKey")) {
            TrustUtil.createKeySizeElement(wstVersion, requestSecurityTokenResponse, rahasData.getKeySize());
        }
        if (this.tokenIssuerConfiguration.isAddRequestedAttachedRef()) {
            TrustUtil.createRequestedAttachedRef(wstVersion, requestSecurityTokenResponse, "#" + assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        if (this.tokenIssuerConfiguration.isAddRequestedUnattachedRef()) {
            TrustUtil.createRequestedUnattachedRef(wstVersion, requestSecurityTokenResponse, assertion.getID(), "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0");
        }
        if (rahasData.getAppliesToAddress() != null) {
            TrustUtil.createAppliesToElement(requestSecurityTokenResponse, rahasData.getAppliesToAddress(), rahasData.getAddressingNs());
        }
        XmlSchemaDateFormat xmlSchemaDateFormat = new XmlSchemaDateFormat();
        TrustUtil.createLifetimeElement(wstVersion, requestSecurityTokenResponse, xmlSchemaDateFormat.format(rahasData.getAssertionCreatedDate()), xmlSchemaDateFormat.format(rahasData.getAssertionExpiringDate()));
        OMElement requestedSecurityTokenElement = TrustUtil.createRequestedSecurityTokenElement(wstVersion, requestSecurityTokenResponse);
        Element assertionElement = assertion.getDOM();
        requestedSecurityTokenElement.addChild((OMNode)assertionElement);
        Token assertionToken = new Token(assertion.getID(), (OMElement)assertionElement, rahasData.getAssertionCreatedDate(), rahasData.getAssertionExpiringDate());
        assertionToken.setSecret(rahasData.getEphmeralKey());
        TrustUtil.getTokenStore(rahasData.getInMessageContext()).add(assertionToken);
        if (rahasData.getKeyType().endsWith("/SymmetricKey") && this.tokenIssuerConfiguration.getKeyComputation() != 1) {
            Document doc = ((Element)soapEnvelope).getOwnerDocument();
            TokenIssuerUtil.handleRequestedProofToken(rahasData, wstVersion, this.tokenIssuerConfiguration, requestSecurityTokenResponse, assertionToken, doc);
        }
        return soapEnvelope;
    }

    protected Assertion buildAssertion(Document doc, Crypto crypto, RahasData data) throws TrustException {
        Assertion assertion = SAML2Utils.createAssertion();
        Issuer issuer = SAML2Utils.createIssuer(this.tokenIssuerConfiguration.getIssuerName());
        assertion.setIssuer(issuer);
        DateTime creationDate = new DateTime();
        DateTime expirationDate = new DateTime(creationDate.getMillis() + this.tokenIssuerConfiguration.getTtl());
        data.setAssertionCreatedDate(creationDate.toDate());
        data.setAssertionExpiringDate(expirationDate.toDate());
        assertion.setIssueInstant(creationDate);
        Conditions conditions = SAML2Utils.createConditions(creationDate, expirationDate);
        assertion.setConditions(conditions);
        Subject subject = !data.getKeyType().endsWith("/Bearer") ? this.createSubjectWithHolderOfKeySubjectConfirmation(doc, crypto, creationDate, expirationDate, data) : this.createSubjectWithBearerSubjectConfirmation(data);
        assertion.setSubject(subject);
        if (this.isSymmetricKeyBasedHoK) {
            AttributeStatement attrStmt = this.createAttributeStatement(data);
            assertion.getAttributeStatements().add(attrStmt);
        } else {
            AuthnStatement authStmt = this.createAuthenticationStatement(data);
            assertion.getAuthnStatements().add(authStmt);
            if (data.getClaimDialect() != null && data.getClaimElem() != null) {
                assertion.getAttributeStatements().add(this.createAttributeStatement(data));
            }
        }
        return assertion;
    }

    protected Subject createSubjectWithHolderOfKeySubjectConfirmation(Document doc, Crypto crypto, DateTime creationTime, DateTime expirationTime, RahasData data) throws TrustException {
        Subject subject = (Subject)CommonUtil.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        if (data.getPrincipal() != null) {
            SAML2TokenIssuer.setSubjectNamedIdentifierData(subject, data.getPrincipal().getName(), "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        }
        KeyInfo keyInfo = this.createKeyInfo(doc, crypto, data);
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)CommonUtil.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:holder-of-key");
        KeyInfoConfirmationDataType scData = this.createKeyInfoConfirmationDataType();
        scData.getKeyInfos().add(keyInfo);
        scData.setNotBefore(creationTime);
        scData.setNotOnOrAfter(expirationTime);
        subjectConfirmation.setSubjectConfirmationData((SubjectConfirmationData)scData);
        subject.getSubjectConfirmations().add(subjectConfirmation);
        log.debug((Object)"SAML2.0 subject is constructed successfully.");
        return subject;
    }

    private KeyInfoConfirmationDataType createKeyInfoConfirmationDataType() {
        XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
        SAMLObjectBuilder keyInfoSubjectConfirmationDataBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(KeyInfoConfirmationDataType.TYPE_NAME);
        return (KeyInfoConfirmationDataType)keyInfoSubjectConfirmationDataBuilder.buildObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME, KeyInfoConfirmationDataType.TYPE_NAME);
    }

    protected Subject createSubjectWithBearerSubjectConfirmation(RahasData data) throws TrustException {
        Subject subject = (Subject)CommonUtil.buildXMLObject(Subject.DEFAULT_ELEMENT_NAME);
        SAML2TokenIssuer.setSubjectNamedIdentifierData(subject, data.getPrincipal().getName(), "urn:oasis:names:tc:SAML:1.1:nameid-format:emailAddress");
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)CommonUtil.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subject.getSubjectConfirmations().add(subjectConfirmation);
        return subject;
    }

    protected Assertion signAssertion(Document document, Assertion assertion, Crypto crypto) throws TrustException {
        SignKeyHolder signKeyHolder = this.createSignKeyHolder(crypto);
        Signature signature = (Signature)CommonUtil.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSigningCredential((Credential)signKeyHolder);
        signature.setSignatureAlgorithm(signKeyHolder.getSignatureAlgorithm());
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        try {
            KeyInfo keyInfo = (KeyInfo)CommonUtil.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
            X509Data x509Data = (X509Data)CommonUtil.buildXMLObject(X509Data.DEFAULT_ELEMENT_NAME);
            X509Certificate cert = (X509Certificate)CommonUtil.buildXMLObject(X509Certificate.DEFAULT_ELEMENT_NAME);
            String value = Base64.encode((byte[])signKeyHolder.getEntityCertificate().getEncoded());
            cert.setValue(value);
            x509Data.getX509Certificates().add(cert);
            keyInfo.getX509Datas().add(x509Data);
            signature.setKeyInfo(keyInfo);
            assertion.setSignature(signature);
            this.signatureList.add(signature);
            MarshallerFactory marshallerFactory = org.opensaml.xml.Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)assertion);
            marshaller.marshall((XMLObject)assertion, document);
            Signer.signObjects(this.signatureList);
        }
        catch (CertificateEncodingException e) {
            throw new TrustException("Error in setting the signature", e);
        }
        catch (SignatureException e) {
            throw new TrustException("errorSigningAssertion", e);
        }
        catch (MarshallingException e) {
            throw new TrustException("errorMarshallingAssertion", e);
        }
        log.debug((Object)"SAML2.0 assertion is marshalled and signed..");
        return assertion;
    }

    private SignKeyHolder createSignKeyHolder(Crypto crypto) throws TrustException {
        SignKeyHolder signKeyHolder = new SignKeyHolder();
        try {
            java.security.cert.X509Certificate[] issuerCerts = CommonUtil.getCertificatesByAlias(crypto, this.tokenIssuerConfiguration.getIssuerKeyAlias());
            String sigAlgo = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            String pubKeyAlgo = issuerCerts[0].getPublicKey().getAlgorithm();
            if (pubKeyAlgo.equalsIgnoreCase("DSA")) {
                sigAlgo = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            PrivateKey issuerPK = crypto.getPrivateKey(this.tokenIssuerConfiguration.getIssuerKeyAlias(), this.tokenIssuerConfiguration.getIssuerKeyPassword());
            signKeyHolder.setIssuerCerts(issuerCerts);
            signKeyHolder.setIssuerPK(issuerPK);
            signKeyHolder.setSignatureAlgorithm(sigAlgo);
        }
        catch (Exception e) {
            throw new TrustException("Error creating issuer signature");
        }
        log.debug((Object)"SignKeyHolder object is created with the credentials..");
        return signKeyHolder;
    }

    protected AttributeStatement createAttributeStatement(RahasData data) throws TrustException {
        Attribute[] attributes;
        AttributeStatement attributeStatement = (AttributeStatement)CommonUtil.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        SAMLCallbackHandler handler = CommonUtil.getSAMLCallbackHandler(this.tokenIssuerConfiguration, data);
        SAMLAttributeCallback cb = new SAMLAttributeCallback(data);
        if (handler != null) {
            try {
                handler.handle(cb);
            }
            catch (SAMLException e) {
                throw new TrustException("errorCallingSAMLCallback", e);
            }
            attributes = cb.getSAML2Attributes();
        } else {
            log.debug((Object)"No callback registered to get attributes ... Using default attributes");
            Attribute attribute = (Attribute)CommonUtil.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME);
            attribute.setName("Name");
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified");
            XMLObjectBuilderFactory builderFactory = Configuration.getBuilderFactory();
            XSStringBuilder attributeValueBuilder = (XSStringBuilder)builderFactory.getBuilder(XSString.TYPE_NAME);
            XSString stringValue = (XSString)attributeValueBuilder.buildObject(AttributeValue.DEFAULT_ELEMENT_NAME, XSString.TYPE_NAME);
            stringValue.setValue("Colombo/Rahas");
            attribute.getAttributeValues().add(stringValue);
            attributes = new Attribute[]{attribute};
        }
        attributeStatement.getAttributes().addAll(Arrays.asList(attributes));
        log.debug((Object)"SAML2.0 attribute statement is constructed successfully.");
        return attributeStatement;
    }

    protected AuthnStatement createAuthenticationStatement(RahasData data) throws TrustException {
        MessageContext inMsgCtx = data.getInMessageContext();
        AuthnStatement authenticationStatement = (AuthnStatement)CommonUtil.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        authenticationStatement.setAuthnInstant(new DateTime());
        AuthnContext authContext = (AuthnContext)CommonUtil.buildXMLObject(AuthnContext.DEFAULT_ELEMENT_NAME);
        AuthnContextClassRef authCtxClassRef = (AuthnContextClassRef)CommonUtil.buildXMLObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        if (inMsgCtx.getProperty("username") != null) {
            authCtxClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        } else if (inMsgCtx.getProperty("X509Certificate") != null) {
            authCtxClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:X509");
        }
        authContext.setAuthnContextClassRef(authCtxClassRef);
        authenticationStatement.setAuthnContext(authContext);
        log.debug((Object)"SAML2.0 authentication statement is constructed successfully.");
        return authenticationStatement;
    }

    protected static void setSubjectNamedIdentifierData(Subject subject, String subjectNameId, String format) throws TrustException {
        NameID nameID = SAML2Utils.createNamedIdentifier(subjectNameId, format);
        subject.setNameID(nameID);
    }

    protected KeyInfo createKeyInfo(Document doc, Crypto crypto, RahasData data) throws TrustException {
        KeyInfo keyInfo;
        if (data.getKeyType().endsWith("/SymmetricKey")) {
            this.isSymmetricKeyBasedHoK = true;
            java.security.cert.X509Certificate serviceCert = null;
            try {
                serviceCert = this.tokenIssuerConfiguration.getServiceCert(crypto, data.getAppliesToAddress());
                keyInfo = CommonUtil.getSymmetricKeyBasedKeyInfo(doc, data, serviceCert, data.getKeySize(), crypto, this.tokenIssuerConfiguration.getKeyComputation());
            }
            catch (Exception e) {
                if (serviceCert != null) {
                    throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{serviceCert.getSubjectDN().getName()}, e);
                }
                throw new TrustException("errorInBuildingTheEncryptedKeyForPrincipal", new String[]{"UnknownSubjectDN"}, e);
            }
        } else if (data.getKeyType().endsWith("/PublicKey")) {
            try {
                java.security.cert.X509Certificate clientCert = data.getClientCert();
                if (clientCert == null) {
                    clientCert = CommonUtil.getCertificateByAlias(crypto, data.getPrincipal().getName());
                }
                keyInfo = CommonUtil.getCertificateBasedKeyInfo(clientCert);
            }
            catch (Exception e) {
                throw new TrustException("samlAssertionCreationError", e);
            }
        } else {
            log.error((Object)("Unidentified key type " + data.getKeyType()));
            throw new TrustException("unidentifiedKeyType", new String[]{data.getKeyType()});
        }
        return keyInfo;
    }

    public String getResponseAction(RahasData data) throws TrustException {
        return null;
    }

    public void setConfigurationFile(String configFile) {
        this.configFile = configFile;
    }

    public void setConfigurationElement(OMElement configElement) {
        this.configElement = configElement;
    }

    public void setConfigurationParamName(String configParamName) {
        this.configParamName = configParamName;
    }
}

