/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.stress.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.stress.util.Timer;
import org.apache.cassandra.stress.util.TimingInterval;
import org.apache.cassandra.stress.util.TimingIntervals;

public class Timing {
    private final Map<String, List<Timer>> timers = new TreeMap<String, List<Timer>>();
    private volatile TimingIntervals history;
    private final int historySampleCount;
    private final int reportSampleCount;
    private boolean done;

    public Timing(int historySampleCount, int reportSampleCount) {
        this.historySampleCount = historySampleCount;
        this.reportSampleCount = reportSampleCount;
    }

    public <E> TimingResult<E> snap(Callable<E> call) throws InterruptedException {
        int n;
        E e;
        int timerCount = 0;
        for (List<Timer> list : this.timers.values()) {
            timerCount += list.size();
        }
        CountDownLatch ready = new CountDownLatch(timerCount);
        for (List<Timer> list : this.timers.values()) {
            for (Object timer : list) {
                ((Timer)timer).requestReport(ready);
            }
        }
        try {
            e = call.call();
        }
        catch (Exception exception) {
            if (exception instanceof InterruptedException) {
                throw (InterruptedException)exception;
            }
            throw new RuntimeException(exception);
        }
        if (!ready.await(5L, TimeUnit.MINUTES)) {
            throw new RuntimeException("Timed out waiting for a timer thread - seems one got stuck. Check GC/Heap size");
        }
        boolean bl = true;
        TreeMap<String, TimingInterval> intervals = new TreeMap<String, TimingInterval>();
        for (Map.Entry entry : this.timers.entrySet()) {
            ArrayList<TimingInterval> operationIntervals = new ArrayList<TimingInterval>();
            for (Timer timer : (List)entry.getValue()) {
                operationIntervals.add(timer.report);
                n &= !timer.running() ? 1 : 0;
            }
            intervals.put((String)entry.getKey(), TimingInterval.merge(operationIntervals, this.reportSampleCount, this.history.get((String)entry.getKey()).endNanos()));
        }
        TimingIntervals result = new TimingIntervals(intervals);
        this.done = n;
        this.history = this.history.merge(result, this.historySampleCount, this.history.startNanos());
        return new TimingResult<E>(e, result);
    }

    public Timer newTimer(String opType, int sampleCount) {
        Timer timer = new Timer(sampleCount);
        if (!this.timers.containsKey(opType)) {
            this.timers.put(opType, new ArrayList());
        }
        this.timers.get(opType).add(timer);
        return timer;
    }

    public void start() {
        this.history = new TimingIntervals(this.timers.keySet());
    }

    public boolean done() {
        return this.done;
    }

    public TimingIntervals getHistory() {
        return this.history;
    }

    public static class TimingResult<E> {
        public final E extra;
        public final TimingIntervals intervals;

        public TimingResult(E extra, TimingIntervals intervals) {
            this.extra = extra;
            this.intervals = intervals;
        }
    }
}

