/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.api.core.metadata.schema;

import com.datastax.dse.driver.api.core.metadata.schema.DseEdgeMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseTableMetadata;
import com.datastax.dse.driver.api.core.metadata.schema.DseVertexMetadata;
import com.datastax.dse.driver.internal.core.metadata.schema.ScriptHelper;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.internal.core.metadata.schema.ScriptBuilder;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.RelationParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Map;
import java.util.Optional;

public interface DseGraphTableMetadata
extends DseTableMetadata {
    @NonNull
    public Optional<DseVertexMetadata> getVertex();

    @NonNull
    public Optional<DseEdgeMetadata> getEdge();

    @Override
    @NonNull
    default public String describe(boolean pretty) {
        ScriptBuilder builder = new ScriptBuilder(pretty);
        if (this.isVirtual()) {
            builder.append("/* VIRTUAL ");
        } else {
            builder.append("CREATE ");
        }
        builder.append("TABLE ").append(this.getKeyspace()).append(".").append(this.getName()).append(" (").newLine().increaseIndent();
        for (ColumnMetadata columnMetadata : this.getColumns().values()) {
            builder.append(columnMetadata.getName()).append(" ").append(columnMetadata.getType().asCql(true, pretty));
            if (columnMetadata.isStatic()) {
                builder.append(" static");
            }
            builder.append(",").newLine();
        }
        builder.append("PRIMARY KEY (");
        if (this.getPartitionKey().size() == 1) {
            builder.append(this.getPartitionKey().get(0).getName());
        } else {
            builder.append("(");
            boolean first = true;
            for (ColumnMetadata pkColumn : this.getPartitionKey()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(pkColumn.getName());
            }
            builder.append(")");
        }
        for (ColumnMetadata columnMetadata : this.getClusteringColumns().keySet()) {
            builder.append(", ").append(columnMetadata.getName());
        }
        builder.append(")");
        builder.newLine().decreaseIndent().append(")");
        builder.increaseIndent();
        if (this.isCompactStorage()) {
            builder.andWith().append("COMPACT STORAGE");
        }
        if (this.getClusteringColumns().containsValue((Object)ClusteringOrder.DESC)) {
            builder.andWith().append("CLUSTERING ORDER BY (");
            boolean first = true;
            for (Map.Entry<ColumnMetadata, ClusteringOrder> entry : this.getClusteringColumns().entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append(entry.getKey().getName()).append(" ").append(entry.getValue().name());
            }
            builder.append(")");
        }
        this.getVertex().ifPresent(vertex -> builder.andWith().append("VERTEX LABEL").append(" ").append(vertex.getLabelName()));
        this.getEdge().ifPresent(edge -> {
            builder.andWith().append("EDGE LABEL").append(" ").append(edge.getLabelName());
            ScriptHelper.appendEdgeSide(builder, edge.getFromTable(), edge.getFromLabel(), edge.getFromPartitionKeyColumns(), edge.getFromClusteringColumns(), "FROM");
            ScriptHelper.appendEdgeSide(builder, edge.getToTable(), edge.getToLabel(), edge.getToPartitionKeyColumns(), edge.getToClusteringColumns(), "TO");
        });
        Map<CqlIdentifier, Object> options = this.getOptions();
        RelationParser.appendOptions(options, builder);
        builder.append(";");
        if (this.isVirtual()) {
            builder.append(" */");
        }
        return builder.build();
    }
}

