Apache CloudStack CloudMonkey Changelog
---------------------------------------

Version 6.5.0
=============
This release includes:
- Adds support for template/ISO file upload
- Adds support for Two-Factor Authentication (2FA) prompts
- Improves autocompletion filtering and listing for different resources, with name/detail-based suggestions
- Enables sending API requests using HTTP POST
- Improves output formatting for multiple formats and asynchronous APIs
- Enhances filtering output, with support for async APIs and reverse filtering via the excludefilter option
- Updates inbuilt API precache to ACS v4.21
- Improves credential fallback for command-line scenario
- Hardens file permissions for config and history file access
- Improves validation when setting configuration values
- Improves overall linting, tests, and automated workflows for the repository

Version 6.4.0
=============
This release includes:
- Improve CLI mode usage and output handling
- Add support for http POST handling for password and user-data
- Optimise async API jobs polling
- Better interrupt handling of Ctrl+C to cancel on-going API request but not
  crash `cmk`
- Remove unnecessary call to listApis (sync) when using CLI mode with url,
  api key, secret key
- Updates inbuilt API precache to ACS v4.19

Version 6.3.0
=============
This release includes:
- Fixes handling of invalid timeout value
- Fixes csv output
- Add support for ARM64 Darwin/OSX build in Makefile
- Autocompletion on storage pool related APIs
- Enable profile information passing through commandline
- Profile caching improvements and bugfixes
- Fix: reuse cmk's CLI params to call piped cmd
- Maintenance changes - github actions/travis migration, dependencies upgrades,
- Various bug fixes 

Version 6.2.0
=============
This release includes:
- Validation of arguments while setting cloudmonkey configuration
- Verify user access to cloudmonkey configuration file
- Allow sync command to be used as a verb for cloudstack API calls
- Print response with newlines if output format chosen is "text"
- Map "default" output type to "json"
- Add autocompletion as an optional configuration
- Display output in human readable format
- Show meaningful metadata for id autocompletion for some APIs

Version 6.1.0
=============
This release includes
- Fix issue of required parameters for tags and details
- Fix issue of hostid parameter completing to show hosts with type=routing
- Statically building the binary to not depend on gcc compiler #59
- Allow http/https web-proxy support #49
- Show keys as per provided filter for table/csv/column output #63
- Don't sort header when filter keys are provided

Version 6.0.0
=============
This release includes
- Rewrite cloudmonkey in golang
- Interactive parameter completion
- Simplification of configuration

Version 5.3.3
=============
This release includes
- Support for shell history
- Sort autocompletion suggestion based on names
- Improve CSV output and error handling

Version 5.3.2
=============
This release includes
- Spinner printing improvements
- Monkey patching SSL requests
- Encode publickey, privatekey and certificates in APIs
- Configurable signature version
- Fix tabular output mode
- Better response checking in the API response
- A new XML display output mode
- A new CSV display output mode

Version 5.3.1
=============
This release includes
- Users can specify domain when using username/password auth per server profile
- Autocompletion of args works when cursor is not at the end of the line
- CLOUDSTACK-7935: keep colons in the request to ACS
- Account parameters are sometimes UUIDs and sometimes string, CloudMonkey
  now automatically autocompletes for both UUID and string account args
- Pass verifysslcert option while user logs in using username/password
- Importing readline no longer outputs escape characters
- CloudMonkey will not output extra empty lines in stdout output
- Filtered result output is uniform across output display formats
- Async blocked API now show a spinning cursor instead of print dots
- When finding missing API args, it does case insensitive search
- New command line arg: -p or --profile (load server profile)
- New command line arg: -b, --block-async (block and poll result on async API calls)
- New command line arg: -n, --noblock-async (do not block on async API calls)

Version 5.3.0
=============
This release includes
- CloudMonkey becomes unicode friendly
- Autocompletion for filters, precache changes
- Autocompletion for config 'set' options and boolean api args
- Current server profile displayed on prompt
- Server profile related bugfixes, blank profile names are not allowed
- Filtering support for default display output
- Filtering by single key only outputs results without key names
- Non-interactive commands from command line are outputted without colors
- Parameter completion uses list api heuristics and related APIs as fallback
- Parameter completion options are cached to speed up rendering of options
- CloudMonkey returns non-zero exit code when run on shell and a error is return
  from management server, the error message is written to stderr
- Adds new config parameter 'verifysslcert' to enable/disable SSL cert checking
- New command line arg: -d for display (json, table or default)

Make sure you backup your config before you upgrade cloudmonkey from previous releases.
With this release `cloudmonkey` will automatically fix your config file, add missing
configuration parameters and save it as the upgraded versions starts for the first time.

Version 5.2.0
=============
This release includes
 - In the config [server] section is deprecated now
 - For missing keys, cloudmonkey will set default values
 - Network requests, json decoding and shell related bugfixes
 - Based on platform, it will install either pyreadline (Windows) or readline (OSX and Linux)
 - Config options `protocol`, `host`, `port`, `path` are deprecated now
 - Backward compatibility exists for above options but we use `url` for the mgmt server URL
 - Introduces server profiles so users can use cloudmonkey with different hosts and management server configs
 - A default profile under the section [local] is added with default values
 - Everytime `set` is called, cloudmonkey will write the config and reload config file

Make sure you backup your config before you upgrade cloudmonkey from previous releases.
With this release `cloudmonkey` will automatically fix your config file, add missing
configuration parameters and save it as the upgraded versions starts for the first time.

Version 5.1.0
=============
This release includes
 - support for using username and password instead of / in addition to api key and secret key
 - Usage of signature version 3 for the api signing process. This reduces the chance of API replay attacks
 - cleanup based on reporting from PEP8 and Flake8

If you upgrade from 5.0, then cloudmonkey will ask you to update your config file (~/.cloudmonkey/config)
Under the [user], you can add
username =
password =
Under the [server], you can add
expires = 600

Version 5.0.0
=============
This is the first release of CloudMonkey independent from the Apache CloudStack core orchestration engine. The release
includes a precache of Apache CloudStack 4.2.0 API calls, and should be backward compatible with prior 3.x and 4.x
CloudStack installations (with the obvious caveat that previous versions will have a subset of the latest API commands /
parameters).
