/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.math.BigInteger;
import org.apache.commons.beanutils2.Converter;
import org.apache.commons.beanutils2.converters.AbstractNumberConverterTest;
import org.apache.commons.beanutils2.converters.BigIntegerConverter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BigIntegerConverterTest
extends AbstractNumberConverterTest<BigInteger> {
    private Converter<BigInteger> converter;

    @Override
    protected Class<BigInteger> getExpectedType() {
        return BigInteger.class;
    }

    protected BigIntegerConverter makeConverter() {
        return new BigIntegerConverter();
    }

    protected BigIntegerConverter makeConverter(BigInteger defaultValue) {
        return new BigIntegerConverter(defaultValue);
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.converter = this.makeConverter();
        this.numbers[0] = new BigInteger("-12");
        this.numbers[1] = new BigInteger("13");
        this.numbers[2] = new BigInteger("-22");
        this.numbers[3] = new BigInteger("23");
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.converter = null;
    }

    @Test
    public void testSimpleConversion() throws Exception {
        String[] message = new String[]{"from String", "from String", "from String", "from String", "from String", "from String", "from String", "from Byte", "from Short", "from Integer", "from Long", "from Float", "from Double"};
        Object[] input = new Object[]{String.valueOf(Long.MIN_VALUE), "-17", "-1", "0", "1", "17", String.valueOf(Long.MAX_VALUE), (byte)7, (short)8, 9, 10L, Float.valueOf(11.1f), 12.2};
        BigInteger[] expected = new BigInteger[]{BigInteger.valueOf(Long.MIN_VALUE), BigInteger.valueOf(-17L), BigInteger.valueOf(-1L), BigInteger.valueOf(0L), BigInteger.valueOf(1L), BigInteger.valueOf(17L), BigInteger.valueOf(Long.MAX_VALUE), BigInteger.valueOf(7L), BigInteger.valueOf(8L), BigInteger.valueOf(9L), BigInteger.valueOf(10L), BigInteger.valueOf(11L), BigInteger.valueOf(12L)};
        for (int i = 0; i < expected.length; ++i) {
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(BigInteger.class, input[i]), (String)(message[i] + " to BigInteger"));
            Assertions.assertEquals((Object)expected[i], (Object)this.converter.convert(null, input[i]), (String)(message[i] + " to null type"));
        }
    }
}

