/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationAssert;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.YAMLConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.yaml.snakeyaml.Yaml;

public class TestYAMLConfiguration {
    @TempDir
    public File tempFolder;
    private final String testYaml = ConfigurationAssert.getTestFile("test.yaml").getAbsolutePath();
    private YAMLConfiguration yamlConfiguration;

    @BeforeEach
    public void setUp() throws Exception {
        this.yamlConfiguration = new YAMLConfiguration();
        this.yamlConfiguration.read((Reader)new FileReader(this.testYaml));
    }

    @Test
    public void testCopyConstructor() {
        BaseHierarchicalConfiguration c = new BaseHierarchicalConfiguration();
        c.addProperty("foo", (Object)"bar");
        this.yamlConfiguration = new YAMLConfiguration((HierarchicalConfiguration)c);
        Assertions.assertEquals((Object)"bar", (Object)this.yamlConfiguration.getString("foo"));
    }

    @Test
    public void testGetPropertyDictionary() {
        Assertions.assertEquals((Object)"Martin D'vloper", (Object)this.yamlConfiguration.getProperty("martin.name"));
        Assertions.assertEquals((Object)"Developer", (Object)this.yamlConfiguration.getProperty("martin.job"));
        Assertions.assertEquals((Object)"Elite", (Object)this.yamlConfiguration.getProperty("martin.skill"));
    }

    @Test
    public void testGetPropertyInteger() {
        Object property = this.yamlConfiguration.getProperty("int1");
        Assertions.assertInstanceOf(Integer.class, (Object)property);
        Assertions.assertEquals((Object)37, (Object)property);
    }

    @Test
    public void testGetPropertyNested() {
        Assertions.assertEquals((Object)"value23", (Object)this.yamlConfiguration.getProperty("key2.key3"));
    }

    @Test
    public void testGetPropertyNestedWithList() {
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)this.yamlConfiguration.getProperty("key4.key5"));
    }

    @Test
    public void testGetPropertySimple() {
        Assertions.assertEquals((Object)"value1", (Object)this.yamlConfiguration.getProperty("key1"));
    }

    @Test
    public void testGetPropertySubset() {
        Configuration subset = this.yamlConfiguration.subset("key4");
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)subset.getProperty("key5"));
    }

    @Test
    public void testGetPropertyVeryNestedProperties() {
        Object property = this.yamlConfiguration.getProperty("very.nested.properties");
        Assertions.assertEquals(Arrays.asList("nested1", "nested2", "nested3"), (Object)property);
    }

    @Test
    public void testObjectCreationFromReader() {
        File createdFile = new File(this.tempFolder, "data.txt");
        String yaml = "!!java.io.FileOutputStream [" + createdFile.getAbsolutePath() + "]";
        StringReader reader = new StringReader(yaml);
        Assertions.assertThrows(ConfigurationException.class, () -> this.yamlConfiguration.read((Reader)reader));
        Assertions.assertFalse((boolean)createdFile.exists());
    }

    @Test
    public void testObjectCreationFromStream() {
        File createdFile = new File(this.tempFolder, "data.txt");
        String yaml = "!!java.io.FileOutputStream [" + createdFile.getAbsolutePath() + "]";
        ByteArrayInputStream inputStream = new ByteArrayInputStream(yaml.getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(ConfigurationException.class, () -> this.yamlConfiguration.read((InputStream)inputStream));
        Assertions.assertFalse((boolean)createdFile.exists());
    }

    @Test
    public void testSave() throws IOException, ConfigurationException {
        StringWriter sw = new StringWriter();
        this.yamlConfiguration.write((Writer)sw);
        String output = sw.toString();
        Map parsed = (Map)new Yaml().loadAs(output, Map.class);
        Assertions.assertEquals((int)6, (int)parsed.entrySet().size());
        Assertions.assertEquals((Object)"value1", parsed.get("key1"));
        Map key2 = (Map)parsed.get("key2");
        Assertions.assertEquals((Object)"value23", key2.get("key3"));
        List key5 = (List)((Map)parsed.get("key4")).get("key5");
        Assertions.assertEquals(Arrays.asList("col1", "col2"), (Object)key5);
    }
}

