/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import org.apache.commons.text.similarity.JaccardSimilarity;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class JaccardSimilarityTest {
    private static JaccardSimilarity classBeingTested;

    @BeforeAll
    public static void setUp() {
        classBeingTested = new JaccardSimilarity();
    }

    @Test
    public void testGettingJaccardSimilarity() {
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)""), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)""), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"", (CharSequence)"right"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.75, (double)classBeingTested.apply((CharSequence)"frog", (CharSequence)"fog"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.0, (double)classBeingTested.apply((CharSequence)"fly", (CharSequence)"ant"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.22, (double)classBeingTested.apply((CharSequence)"elephant", (CharSequence)"hippo"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.64, (double)classBeingTested.apply((CharSequence)"ABC Corporation", (CharSequence)"ABC Corp"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.76, (double)classBeingTested.apply((CharSequence)"D N H Enterprises Inc", (CharSequence)"D & H Enterprises, Inc."), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.89, (double)classBeingTested.apply((CharSequence)"My Gym Children's Fitness Center", (CharSequence)"My Gym. Childrens Fitness"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.9, (double)classBeingTested.apply((CharSequence)"PENNSYLVANIA", (CharSequence)"PENNCISYLVNIA"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.13, (double)classBeingTested.apply((CharSequence)"left", (CharSequence)"right"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)0.13, (double)classBeingTested.apply((CharSequence)"leettteft", (CharSequence)"ritttght"), (double)1.0E-20);
        org.junit.jupiter.api.Assertions.assertEquals((double)1.0, (double)classBeingTested.apply((CharSequence)"the same string", (CharSequence)"the same string"), (double)1.0E-20);
    }

    @Test
    public void testGettingJaccardSimilarityNullNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, null));
    }

    @Test
    public void testGettingJaccardSimilarityStringNull() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply((CharSequence)" ", null));
    }

    @Test
    public void testGettingJaccardSimilarityNullString() {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> classBeingTested.apply(null, (CharSequence)"right"));
    }
}

