/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.scxml.env;

import java.util.Iterator;
import java.util.LinkedList;
import org.apache.commons.scxml.model.Transition;
import org.apache.commons.scxml.model.TransitionTarget;

public final class LogUtils {
    public static String transToString(TransitionTarget from, TransitionTarget to, Transition transition) {
        StringBuffer buf = new StringBuffer("transition (");
        buf.append("event = ").append(transition.getEvent());
        buf.append(", cond = ").append(transition.getCond());
        buf.append(", from = ").append(LogUtils.getTTPath(from));
        buf.append(", to = ").append(LogUtils.getTTPath(to));
        buf.append(')');
        return buf.toString();
    }

    public static String getTTPath(TransitionTarget tt) {
        TransitionTarget parent = tt.getParent();
        if (parent == null) {
            return "/" + tt.getId();
        }
        LinkedList<TransitionTarget> pathElements = new LinkedList<TransitionTarget>();
        pathElements.addFirst(tt);
        while (parent != null) {
            pathElements.addFirst(parent);
            parent = parent.getParent();
        }
        StringBuffer names = new StringBuffer();
        Iterator i = pathElements.iterator();
        while (i.hasNext()) {
            TransitionTarget pathElement = (TransitionTarget)i.next();
            names.append('/').append(pathElement.getId());
        }
        return names.toString();
    }

    private LogUtils() {
    }
}

