/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class PermissionsTests
extends AbstractProviderTestCase {
    public static final String FILENAME = "permission.txt";

    private FileObject createTestFile() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        PermissionsTests.assertNotNull((Object)scratchFolder);
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        PermissionsTests.assertFalse((boolean)file.exists());
        String content = "Here is some sample content for the file.  Blah Blah Blah.";
        try (OutputStream os = file.getContent().getOutputStream();){
            os.write("Here is some sample content for the file.  Blah Blah Blah.".getBytes(StandardCharsets.UTF_8));
        }
        return file;
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.CREATE, Capability.DELETE, Capability.READ_CONTENT, Capability.WRITE_CONTENT};
    }

    private boolean isWindows() {
        return SystemUtils.IS_OS_WINDOWS && this.getFileSystem() instanceof LocalFileSystem;
    }

    protected void tearDown() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        FileObject file = scratchFolder.resolveFile(FILENAME);
        file.setWritable(true, true);
        file.delete();
        super.tearDown();
    }

    @Test
    public void testExecutable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assertions.assertTrue((boolean)file.isExecutable(), (String)("File expected to be executable: " + file));
        } else {
            Assertions.assertTrue((boolean)file.setExecutable(true, true), (String)("Setting executable permission failed: " + file));
            Assertions.assertTrue((boolean)file.isExecutable(), (String)("File expected to be executable: " + file));
            Assertions.assertTrue((boolean)file.setExecutable(true, false), (String)("Setting executable permission failed: " + file));
            Assertions.assertTrue((boolean)file.isExecutable(), (String)("File expected to be executable: " + file));
            Assertions.assertTrue((boolean)file.setExecutable(false, true), (String)("Setting executable permission failed: " + file));
            Assertions.assertFalse((boolean)file.isExecutable(), (String)("File expected to be not executable: " + file));
        }
    }

    @Test
    public void testReadable() throws Exception {
        FileObject file = this.createTestFile();
        if (this.isWindows()) {
            Assertions.assertTrue((boolean)file.isReadable(), (String)("File expected to be readable: " + file));
        } else {
            Assertions.assertTrue((boolean)file.setReadable(true, true), (String)("Setting read permission failed: " + file));
            Assertions.assertTrue((boolean)file.isReadable(), (String)("File expected to be readable: " + file));
            Assertions.assertTrue((boolean)file.setReadable(true, false), (String)("Setting read permission failed: " + file));
            Assertions.assertTrue((boolean)file.isReadable(), (String)("File expected to be readable: " + file));
            Assertions.assertTrue((boolean)file.setReadable(false, true), (String)("Setting read permission failed: " + file));
            Assertions.assertFalse((boolean)file.isReadable(), (String)("File expected to be not readable: " + file));
        }
    }

    @Test
    public void testWriteable() throws Exception {
        FileObject file = this.createTestFile();
        Assertions.assertTrue((boolean)file.setWritable(true, true), (String)("Setting write permission failed: " + file));
        Assertions.assertTrue((boolean)file.isWriteable(), (String)("File expected to be writable: " + file));
        Assertions.assertTrue((boolean)file.setWritable(true, false), (String)("Setting write permission failed: " + file));
        Assertions.assertTrue((boolean)file.isWriteable(), (String)("File expected to be writable: " + file));
        Assertions.assertTrue((boolean)file.setWritable(false, true), (String)("Setting write permission failed: " + file));
        Assertions.assertFalse((boolean)file.isWriteable(), (String)("File expected to be not writable: " + file));
    }
}

