/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2;

import java.io.IOException;
import org.apache.commons.vfs2.AbstractProviderTestCase;
import org.apache.commons.vfs2.Capability;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.RandomAccessContent;
import org.apache.commons.vfs2.Selectors;
import org.apache.commons.vfs2.util.RandomAccessMode;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;

public class ProviderRandomSetLengthTests
extends AbstractProviderTestCase {
    private static final String TEST_DATA = "This is a test file.";

    protected FileObject createScratchFolder() throws Exception {
        FileObject scratchFolder = this.getWriteFolder();
        scratchFolder.delete(Selectors.EXCLUDE_SELF);
        scratchFolder.createFolder();
        return scratchFolder;
    }

    @Override
    protected Capability[] getRequiredCapabilities() {
        return new Capability[]{Capability.GET_TYPE, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE, Capability.RANDOM_ACCESS_SET_LENGTH};
    }

    @Test
    public void testRandomSetLength() throws Exception {
        try (FileObject file = this.createScratchFolder().resolveFile("random_write.txt");){
            file.createFile();
            String fileString = file.toString();
            RandomAccessContent ra = file.getContent().getRandomAccessContent(RandomAccessMode.READWRITE);
            ra.writeBytes(TEST_DATA);
            Assertions.assertEquals((long)TEST_DATA.length(), (long)ra.length(), (String)fileString);
            ra.setLength(1L);
            Assertions.assertEquals((long)1L, (long)ra.length(), (String)fileString);
            ra.seek(0L);
            Assertions.assertEquals((int)TEST_DATA.charAt(0), (int)ra.readByte(), (String)fileString);
            try {
                ra.readByte();
                Assertions.fail((String)("Expected " + Exception.class.getName()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ra.setLength(2L);
            Assertions.assertEquals((long)2L, (long)ra.length(), (String)fileString);
            ra.seek(1L);
            ra.readByte();
        }
    }
}

