/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftp;

import java.io.IOException;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.VFS;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.provider.ftp.FtpProviderTestCase;
import org.apache.ftpserver.ftplet.FtpException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class MultipleConnectionTest {
    @BeforeAll
    public static void setUpClass() throws FtpException {
        FtpProviderTestCase.setUpClass(VfsTestUtils.getTestDirectory(), null, null);
    }

    @AfterAll
    public static void tearDownClass() {
        FtpProviderTestCase.tearDownClass();
    }

    private FileObject resolveRoot() throws FileSystemException {
        return VFS.getManager().resolveFile(FtpProviderTestCase.getConnectionUri());
    }

    @Test
    public void testConnectRoot() throws IOException {
        this.resolveRoot();
        this.resolveRoot();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUnderlyingConnect() throws SocketException, IOException {
        FTPClient client1 = new FTPClient();
        FTPClient client2 = new FTPClient();
        try {
            String hostname = "localhost";
            client1.connect("localhost", FtpProviderTestCase.getSocketPort());
            client2.connect("localhost", FtpProviderTestCase.getSocketPort());
        }
        finally {
            client1.disconnect();
            client2.disconnect();
        }
    }
}

