/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.File;
import java.nio.charset.StandardCharsets;
import junit.framework.Test;
import org.apache.commons.vfs2.AbstractProviderTestConfig;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.ProviderTestSuite;
import org.apache.commons.vfs2.VfsTestUtils;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.commons.vfs2.provider.FileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileProvider;
import org.apache.commons.vfs2.provider.zip.ZipFileSystem;
import org.apache.commons.vfs2.provider.zip.ZipFileSystemConfigBuilder;
import org.junit.jupiter.api.Assertions;

public class ZipProviderWithCharsetTestCase
extends AbstractProviderTestConfig {
    public static Test suite() throws Exception {
        return new ProviderTestSuite(new ZipProviderWithCharsetTestCase(), true);
    }

    @Override
    public FileObject getBaseTestFolder(FileSystemManager manager) throws Exception {
        FileSystemOptions opts = new FileSystemOptions();
        ZipFileSystemConfigBuilder builder = ZipFileSystemConfigBuilder.getInstance();
        builder.setCharset(opts, StandardCharsets.UTF_8);
        File zipFile = VfsTestUtils.getTestResource("test.zip");
        String uri = "zip:file:" + zipFile.getAbsolutePath() + "!/";
        FileObject resolvedFile = manager.resolveFile(uri, opts);
        FileSystem fileSystem = resolvedFile.getFileSystem();
        Assertions.assertInstanceOf(ZipFileSystem.class, (Object)fileSystem);
        ZipFileSystem zipFileSystem = (ZipFileSystem)fileSystem;
        Assertions.assertEquals((Object)StandardCharsets.UTF_8, (Object)zipFileSystem.getCharset());
        return resolvedFile;
    }

    @Override
    public void prepare(DefaultFileSystemManager manager) throws Exception {
        manager.addProvider("zip", (FileProvider)new ZipFileProvider());
        manager.addExtensionMap("zip", "zip");
        manager.addMimeTypeMap("application/zip", "zip");
    }
}

