/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.tools;

import java.util.Collection;

public class MaskingClassLoader
extends ClassLoader {
    private final String[] masks;

    public MaskingClassLoader(String ... masks) {
        this.masks = masks;
    }

    public MaskingClassLoader(Collection<String> masks) {
        this(masks.toArray(new String[0]));
    }

    public MaskingClassLoader(ClassLoader parent, String ... masks) {
        super(parent);
        this.masks = masks;
    }

    public MaskingClassLoader(ClassLoader parent, Collection<String> masks) {
        this(parent, masks.toArray(new String[0]));
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (String mask : this.masks) {
            if (!name.startsWith(mask)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }
}

