/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import java.util.ArrayList;
import org.apache.directory.studio.connection.core.jobs.StudioConnectionRunnableWithProgress;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidget;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetPreferences;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.StudioBrowserJob;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EntryEditorWidgetContentProvider
implements ITreeContentProvider {
    protected EntryEditorWidgetPreferences preferences;
    protected EntryEditorWidget mainWidget;

    public EntryEditorWidgetContentProvider(EntryEditorWidgetPreferences preferences, EntryEditorWidget mainWidget) {
        this.preferences = preferences;
        this.mainWidget = mainWidget;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this.mainWidget != null) {
            String dn = "";
            boolean enabled = true;
            if (newInput instanceof IEntry) {
                IEntry entry = (IEntry)newInput;
                dn = String.valueOf(Messages.getString("EntryEditorWidgetContentProvider.DNLabel")) + entry.getDn().getName();
            } else if (newInput instanceof AttributeHierarchy) {
                AttributeHierarchy ah = (AttributeHierarchy)newInput;
                dn = String.valueOf(Messages.getString("EntryEditorWidgetContentProvider.DNLabel")) + ah.getAttribute().getEntry().getDn().getName();
            } else {
                dn = Messages.getString("EntryEditorWidgetContentProvider.NoEntrySelected");
                enabled = false;
            }
            if (this.mainWidget.getInfoText() != null && !this.mainWidget.getInfoText().isDisposed()) {
                this.mainWidget.getInfoText().setText(dn);
            }
            if (this.mainWidget.getQuickFilterWidget() != null) {
                this.mainWidget.getQuickFilterWidget().setEnabled(enabled);
            }
            if (this.mainWidget.getViewer() != null && !this.mainWidget.getViewer().getTree().isDisposed()) {
                this.mainWidget.getViewer().getTree().setEnabled(enabled);
            }
        }
    }

    public void dispose() {
        this.preferences = null;
        this.mainWidget = null;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof IEntry) {
            IEntry entry = (IEntry)inputElement;
            if (!entry.isAttributesInitialized()) {
                InitializeAttributesRunnable runnable = new InitializeAttributesRunnable(new IEntry[]{entry});
                StudioBrowserJob job = new StudioBrowserJob(new StudioConnectionRunnableWithProgress[]{runnable});
                job.execute();
                return new Object[0];
            }
            IAttribute[] attributes = entry.getAttributes();
            Object[] values = this.getValues(attributes);
            return values;
        }
        if (inputElement instanceof AttributeHierarchy) {
            AttributeHierarchy ah = (AttributeHierarchy)inputElement;
            IAttribute[] attributes = ah.getAttributes();
            Object[] values = this.getValues(attributes);
            return values;
        }
        return new Object[0];
    }

    private Object[] getValues(IAttribute[] attributes) {
        ArrayList<Object> valueList = new ArrayList<Object>();
        if (attributes != null) {
            IAttribute[] iAttributeArray = attributes;
            int n = attributes.length;
            int n2 = 0;
            while (n2 < n) {
                IAttribute attribute = iAttributeArray[n2];
                IValue[] values = attribute.getValues();
                if (this.preferences == null || !this.preferences.isUseFolding() || values.length <= this.preferences.getFoldingThreshold()) {
                    IValue[] iValueArray = values;
                    int n3 = values.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IValue value = iValueArray[n4];
                        valueList.add(value);
                        ++n4;
                    }
                } else {
                    valueList.add(attribute);
                }
                ++n2;
            }
        }
        return valueList.toArray();
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IAttribute) {
            IAttribute attribute = (IAttribute)parentElement;
            Object[] values = attribute.getValues();
            return values;
        }
        return null;
    }

    public Object getParent(Object element) {
        if (element instanceof IValue) {
            return ((IValue)element).getAttribute();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IAttribute;
    }
}

