/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.storage.s3;

import com.google.auto.service.AutoService;
import org.apache.dolphinscheduler.common.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.api.StorageOperatorFactory;
import org.apache.dolphinscheduler.plugin.storage.api.StorageType;
import org.apache.dolphinscheduler.plugin.storage.s3.S3StorageOperator;
import org.apache.dolphinscheduler.plugin.storage.s3.S3StorageProperties;

@AutoService(value={StorageOperatorFactory.class})
public class S3StorageOperatorFactory
implements StorageOperatorFactory {
    public StorageOperator createStorageOperate() {
        S3StorageProperties s3StorageProperties = this.getS3StorageProperties();
        return new S3StorageOperator(s3StorageProperties);
    }

    private S3StorageProperties getS3StorageProperties() {
        return S3StorageProperties.builder().bucketName(PropertyUtils.getString((String)"aws.s3.bucket.name")).s3Configuration(PropertyUtils.getByPrefix((String)"aws.s3.", (String)"")).resourceUploadPath(PropertyUtils.getString((String)"resource.storage.upload.base.path", (String)"/dolphinscheduler")).build();
    }

    public StorageType getStorageOperate() {
        return StorageType.S3;
    }
}

