/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimCondition;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimConditionBuilder;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimStatus;
import io.kubernetes.client.openapi.models.V1PersistentVolumeClaimStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class V1PersistentVolumeClaimStatusFluentImpl<A extends V1PersistentVolumeClaimStatusFluent<A>>
extends BaseFluent<A>
implements V1PersistentVolumeClaimStatusFluent<A> {
    private List<String> accessModes;
    private Map<String, Quantity> capacity;
    private List<V1PersistentVolumeClaimConditionBuilder> conditions;
    private String phase;

    public V1PersistentVolumeClaimStatusFluentImpl() {
    }

    public V1PersistentVolumeClaimStatusFluentImpl(V1PersistentVolumeClaimStatus instance) {
        this.withAccessModes(instance.getAccessModes());
        this.withCapacity(instance.getCapacity());
        this.withConditions(instance.getConditions());
        this.withPhase(instance.getPhase());
    }

    @Override
    public A addToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAccessModes(int index, String item) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        this.accessModes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAccessModes(String ... items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAccessModes(Collection<String> items) {
        if (this.accessModes == null) {
            this.accessModes = new ArrayList<String>();
        }
        for (String item : items) {
            this.accessModes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAccessModes(String ... items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAccessModes(Collection<String> items) {
        for (String item : items) {
            if (this.accessModes == null) continue;
            this.accessModes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAccessModes() {
        return this.accessModes;
    }

    @Override
    public String getAccessMode(int index) {
        return this.accessModes.get(index);
    }

    @Override
    public String getFirstAccessMode() {
        return this.accessModes.get(0);
    }

    @Override
    public String getLastAccessMode() {
        return this.accessModes.get(this.accessModes.size() - 1);
    }

    @Override
    public String getMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAccessMode(Predicate<String> predicate) {
        for (String item : this.accessModes) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAccessModes(List<String> accessModes) {
        if (this.accessModes != null) {
            this._visitables.get("accessModes").removeAll(this.accessModes);
        }
        if (accessModes != null) {
            this.accessModes = new ArrayList<String>();
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        } else {
            this.accessModes = null;
        }
        return (A)this;
    }

    @Override
    public A withAccessModes(String ... accessModes) {
        if (this.accessModes != null) {
            this.accessModes.clear();
        }
        if (accessModes != null) {
            for (String item : accessModes) {
                this.addToAccessModes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAccessModes() {
        return this.accessModes != null && !this.accessModes.isEmpty();
    }

    @Override
    public A addNewAccessMode(String original) {
        return this.addToAccessModes(new String(original));
    }

    @Override
    public A addToCapacity(String key, Quantity value) {
        if (this.capacity == null && key != null && value != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (key != null && value != null) {
            this.capacity.put(key, value);
        }
        return (A)this;
    }

    @Override
    public A addToCapacity(Map<String, Quantity> map) {
        if (this.capacity == null && map != null) {
            this.capacity = new LinkedHashMap<String, Quantity>();
        }
        if (map != null) {
            this.capacity.putAll(map);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(String key) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (key != null && this.capacity != null) {
            this.capacity.remove(key);
        }
        return (A)this;
    }

    @Override
    public A removeFromCapacity(Map<String, Quantity> map) {
        if (this.capacity == null) {
            return (A)this;
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.capacity == null) continue;
                this.capacity.remove(key);
            }
        }
        return (A)this;
    }

    @Override
    public Map<String, Quantity> getCapacity() {
        return this.capacity;
    }

    @Override
    public <K, V> A withCapacity(Map<String, Quantity> capacity) {
        this.capacity = capacity == null ? null : new LinkedHashMap<String, Quantity>(capacity);
        return (A)this;
    }

    @Override
    public Boolean hasCapacity() {
        return this.capacity != null;
    }

    @Override
    public A addToConditions(int index, V1PersistentVolumeClaimCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimConditionBuilder>();
        }
        V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
        this._visitables.get("conditions").add(index >= 0 ? index : this._visitables.get("conditions").size(), builder);
        this.conditions.add(index >= 0 ? index : this.conditions.size(), builder);
        return (A)this;
    }

    @Override
    public A setToConditions(int index, V1PersistentVolumeClaimCondition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimConditionBuilder>();
        }
        V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
        if (index < 0 || index >= this._visitables.get("conditions").size()) {
            this._visitables.get("conditions").add(builder);
        } else {
            this._visitables.get("conditions").set(index, builder);
        }
        if (index < 0 || index >= this.conditions.size()) {
            this.conditions.add(builder);
        } else {
            this.conditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToConditions(V1PersistentVolumeClaimCondition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimConditionBuilder>();
        }
        for (V1PersistentVolumeClaimCondition item : items) {
            V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToConditions(Collection<V1PersistentVolumeClaimCondition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimConditionBuilder>();
        }
        for (V1PersistentVolumeClaimCondition item : items) {
            V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
            this._visitables.get("conditions").add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(V1PersistentVolumeClaimCondition ... items) {
        for (V1PersistentVolumeClaimCondition item : items) {
            V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromConditions(Collection<V1PersistentVolumeClaimCondition> items) {
        for (V1PersistentVolumeClaimCondition item : items) {
            V1PersistentVolumeClaimConditionBuilder builder = new V1PersistentVolumeClaimConditionBuilder(item);
            this._visitables.get("conditions").remove(builder);
            if (this.conditions == null) continue;
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromConditions(Predicate<V1PersistentVolumeClaimConditionBuilder> predicate) {
        if (this.conditions == null) {
            return (A)this;
        }
        Iterator<V1PersistentVolumeClaimConditionBuilder> each = this.conditions.iterator();
        Object visitables = this._visitables.get("conditions");
        while (each.hasNext()) {
            V1PersistentVolumeClaimConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1PersistentVolumeClaimCondition> getConditions() {
        return V1PersistentVolumeClaimStatusFluentImpl.build(this.conditions);
    }

    @Override
    public List<V1PersistentVolumeClaimCondition> buildConditions() {
        return V1PersistentVolumeClaimStatusFluentImpl.build(this.conditions);
    }

    @Override
    public V1PersistentVolumeClaimCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    @Override
    public V1PersistentVolumeClaimCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    @Override
    public V1PersistentVolumeClaimCondition buildLastCondition() {
        return this.conditions.get(this.conditions.size() - 1).build();
    }

    @Override
    public V1PersistentVolumeClaimCondition buildMatchingCondition(Predicate<V1PersistentVolumeClaimConditionBuilder> predicate) {
        for (V1PersistentVolumeClaimConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingCondition(Predicate<V1PersistentVolumeClaimConditionBuilder> predicate) {
        for (V1PersistentVolumeClaimConditionBuilder item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withConditions(List<V1PersistentVolumeClaimCondition> conditions) {
        if (this.conditions != null) {
            this._visitables.get("conditions").removeAll(this.conditions);
        }
        if (conditions != null) {
            this.conditions = new ArrayList<V1PersistentVolumeClaimConditionBuilder>();
            for (V1PersistentVolumeClaimCondition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)this;
    }

    @Override
    public A withConditions(V1PersistentVolumeClaimCondition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
        }
        if (conditions != null) {
            for (V1PersistentVolumeClaimCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> addNewConditionLike(V1PersistentVolumeClaimCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> setNewConditionLike(int index, V1PersistentVolumeClaimCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (this.conditions.size() <= index) {
            throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (this.conditions.size() == 0) {
            throw new RuntimeException("Can't edit first conditions. The list is empty.");
        }
        return this.setNewConditionLike(0, this.buildCondition(0));
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = this.conditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last conditions. The list is empty.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public V1PersistentVolumeClaimStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<V1PersistentVolumeClaimConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.conditions.size(); ++i) {
            if (!predicate.test(this.conditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching conditions. No match found.");
        }
        return this.setNewConditionLike(index, this.buildCondition(index));
    }

    @Override
    public String getPhase() {
        return this.phase;
    }

    @Override
    public A withPhase(String phase) {
        this.phase = phase;
        return (A)this;
    }

    @Override
    public Boolean hasPhase() {
        return this.phase != null;
    }

    @Override
    @Deprecated
    public A withNewPhase(String original) {
        return this.withPhase(new String(original));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1PersistentVolumeClaimStatusFluentImpl that = (V1PersistentVolumeClaimStatusFluentImpl)o;
        if (this.accessModes != null ? !this.accessModes.equals(that.accessModes) : that.accessModes != null) {
            return false;
        }
        if (this.capacity != null ? !this.capacity.equals(that.capacity) : that.capacity != null) {
            return false;
        }
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        return !(this.phase != null ? !this.phase.equals(that.phase) : that.phase != null);
    }

    public int hashCode() {
        return Objects.hash(this.accessModes, this.capacity, this.conditions, this.phase, super.hashCode());
    }

    public class ConditionsNestedImpl<N>
    extends V1PersistentVolumeClaimConditionFluentImpl<V1PersistentVolumeClaimStatusFluent.ConditionsNested<N>>
    implements V1PersistentVolumeClaimStatusFluent.ConditionsNested<N>,
    Nested<N> {
        private final V1PersistentVolumeClaimConditionBuilder builder;
        private final int index;

        ConditionsNestedImpl(int index, V1PersistentVolumeClaimCondition item) {
            this.index = index;
            this.builder = new V1PersistentVolumeClaimConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1PersistentVolumeClaimConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1PersistentVolumeClaimStatusFluentImpl.this.setToConditions(this.index, this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

