/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.RequestConfig;
import io.fabric8.kubernetes.client.dsl.FunctionCallable;
import java.util.function.Function;

public class WithRequestCallable<C extends Client>
implements FunctionCallable<C> {
    private final C client;
    private final RequestConfig requestConfig;

    public WithRequestCallable(C client, RequestConfig requestConfig) {
        this.client = client;
        this.requestConfig = requestConfig;
    }

    @Override
    public <O> O call(Function<C, O> function) {
        try (Object newClient = this.client.newClient(this.requestConfig).adapt(this.client.getClass());){
            O o = function.apply(newClient);
            return o;
        }
    }
}

