/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.datasource.api.plugin;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannel;
import org.apache.dolphinscheduler.spi.datasource.DataSourceChannelFactory;
import org.apache.dolphinscheduler.spi.enums.DbType;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSourcePluginManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataSourcePluginManager.class);
    private final Map<String, DataSourceChannel> datasourceChannelMap = new ConcurrentHashMap<String, DataSourceChannel>();

    public DataSourceChannel getDataSourceChannel(DbType dbType) {
        return this.datasourceChannelMap.get(dbType.getName());
    }

    public void installPlugin() {
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(DataSourceChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            DataSourceChannelFactory factory = (DataSourceChannelFactory)entry.getValue();
            String name = (String)entry.getKey();
            log.info("Registering datasource plugin: {}", (Object)name);
            if (this.datasourceChannelMap.containsKey(name)) {
                throw new IllegalStateException(String.format("Duplicate datasource plugins named '%s'", name));
            }
            this.loadDatasourceClient(factory);
            log.info("Registered datasource plugin: {}", (Object)name);
        }
    }

    private void loadDatasourceClient(DataSourceChannelFactory datasourceChannelFactory) {
        DataSourceChannel datasourceChannel = datasourceChannelFactory.create();
        this.datasourceChannelMap.put(datasourceChannelFactory.getName(), datasourceChannel);
    }
}

