/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.MetricDefinition;
import com.amazonaws.services.sagemaker.model.TrainingInputMode;
import com.amazonaws.services.sagemaker.model.transform.AlgorithmSpecificationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AlgorithmSpecification
implements Serializable,
Cloneable,
StructuredPojo {
    private String trainingImage;
    private String algorithmName;
    private String trainingInputMode;
    private List<MetricDefinition> metricDefinitions;
    private Boolean enableSageMakerMetricsTimeSeries;

    public void setTrainingImage(String trainingImage) {
        this.trainingImage = trainingImage;
    }

    public String getTrainingImage() {
        return this.trainingImage;
    }

    public AlgorithmSpecification withTrainingImage(String trainingImage) {
        this.setTrainingImage(trainingImage);
        return this;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public AlgorithmSpecification withAlgorithmName(String algorithmName) {
        this.setAlgorithmName(algorithmName);
        return this;
    }

    public void setTrainingInputMode(String trainingInputMode) {
        this.trainingInputMode = trainingInputMode;
    }

    public String getTrainingInputMode() {
        return this.trainingInputMode;
    }

    public AlgorithmSpecification withTrainingInputMode(String trainingInputMode) {
        this.setTrainingInputMode(trainingInputMode);
        return this;
    }

    public AlgorithmSpecification withTrainingInputMode(TrainingInputMode trainingInputMode) {
        this.trainingInputMode = trainingInputMode.toString();
        return this;
    }

    public List<MetricDefinition> getMetricDefinitions() {
        return this.metricDefinitions;
    }

    public void setMetricDefinitions(Collection<MetricDefinition> metricDefinitions) {
        if (metricDefinitions == null) {
            this.metricDefinitions = null;
            return;
        }
        this.metricDefinitions = new ArrayList<MetricDefinition>(metricDefinitions);
    }

    public AlgorithmSpecification withMetricDefinitions(MetricDefinition ... metricDefinitions) {
        if (this.metricDefinitions == null) {
            this.setMetricDefinitions(new ArrayList<MetricDefinition>(metricDefinitions.length));
        }
        for (MetricDefinition ele : metricDefinitions) {
            this.metricDefinitions.add(ele);
        }
        return this;
    }

    public AlgorithmSpecification withMetricDefinitions(Collection<MetricDefinition> metricDefinitions) {
        this.setMetricDefinitions(metricDefinitions);
        return this;
    }

    public void setEnableSageMakerMetricsTimeSeries(Boolean enableSageMakerMetricsTimeSeries) {
        this.enableSageMakerMetricsTimeSeries = enableSageMakerMetricsTimeSeries;
    }

    public Boolean getEnableSageMakerMetricsTimeSeries() {
        return this.enableSageMakerMetricsTimeSeries;
    }

    public AlgorithmSpecification withEnableSageMakerMetricsTimeSeries(Boolean enableSageMakerMetricsTimeSeries) {
        this.setEnableSageMakerMetricsTimeSeries(enableSageMakerMetricsTimeSeries);
        return this;
    }

    public Boolean isEnableSageMakerMetricsTimeSeries() {
        return this.enableSageMakerMetricsTimeSeries;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTrainingImage() != null) {
            sb.append("TrainingImage: ").append(this.getTrainingImage()).append(",");
        }
        if (this.getAlgorithmName() != null) {
            sb.append("AlgorithmName: ").append(this.getAlgorithmName()).append(",");
        }
        if (this.getTrainingInputMode() != null) {
            sb.append("TrainingInputMode: ").append(this.getTrainingInputMode()).append(",");
        }
        if (this.getMetricDefinitions() != null) {
            sb.append("MetricDefinitions: ").append(this.getMetricDefinitions()).append(",");
        }
        if (this.getEnableSageMakerMetricsTimeSeries() != null) {
            sb.append("EnableSageMakerMetricsTimeSeries: ").append(this.getEnableSageMakerMetricsTimeSeries());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AlgorithmSpecification)) {
            return false;
        }
        AlgorithmSpecification other = (AlgorithmSpecification)obj;
        if (other.getTrainingImage() == null ^ this.getTrainingImage() == null) {
            return false;
        }
        if (other.getTrainingImage() != null && !other.getTrainingImage().equals(this.getTrainingImage())) {
            return false;
        }
        if (other.getAlgorithmName() == null ^ this.getAlgorithmName() == null) {
            return false;
        }
        if (other.getAlgorithmName() != null && !other.getAlgorithmName().equals(this.getAlgorithmName())) {
            return false;
        }
        if (other.getTrainingInputMode() == null ^ this.getTrainingInputMode() == null) {
            return false;
        }
        if (other.getTrainingInputMode() != null && !other.getTrainingInputMode().equals(this.getTrainingInputMode())) {
            return false;
        }
        if (other.getMetricDefinitions() == null ^ this.getMetricDefinitions() == null) {
            return false;
        }
        if (other.getMetricDefinitions() != null && !other.getMetricDefinitions().equals(this.getMetricDefinitions())) {
            return false;
        }
        if (other.getEnableSageMakerMetricsTimeSeries() == null ^ this.getEnableSageMakerMetricsTimeSeries() == null) {
            return false;
        }
        return other.getEnableSageMakerMetricsTimeSeries() == null || other.getEnableSageMakerMetricsTimeSeries().equals(this.getEnableSageMakerMetricsTimeSeries());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTrainingImage() == null ? 0 : this.getTrainingImage().hashCode());
        hashCode = 31 * hashCode + (this.getAlgorithmName() == null ? 0 : this.getAlgorithmName().hashCode());
        hashCode = 31 * hashCode + (this.getTrainingInputMode() == null ? 0 : this.getTrainingInputMode().hashCode());
        hashCode = 31 * hashCode + (this.getMetricDefinitions() == null ? 0 : this.getMetricDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getEnableSageMakerMetricsTimeSeries() == null ? 0 : this.getEnableSageMakerMetricsTimeSeries().hashCode());
        return hashCode;
    }

    public AlgorithmSpecification clone() {
        try {
            return (AlgorithmSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AlgorithmSpecificationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

