/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPath;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPathFluent;
import io.fabric8.kubernetes.api.model.networking.v1beta1.HTTPIngressPathFluentImpl;
import java.util.Objects;

public class HTTPIngressPathBuilder
extends HTTPIngressPathFluentImpl<HTTPIngressPathBuilder>
implements VisitableBuilder<HTTPIngressPath, HTTPIngressPathBuilder> {
    HTTPIngressPathFluent<?> fluent;
    Boolean validationEnabled;

    public HTTPIngressPathBuilder() {
        this(false);
    }

    public HTTPIngressPathBuilder(Boolean validationEnabled) {
        this(new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new HTTPIngressPath(), validationEnabled);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance) {
        this(fluent, instance, false);
    }

    public HTTPIngressPathBuilder(HTTPIngressPathFluent<?> fluent, HTTPIngressPath instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withBackend(instance.getBackend());
        fluent.withPath(instance.getPath());
        fluent.withPathType(instance.getPathType());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance) {
        this(instance, (Boolean)false);
    }

    public HTTPIngressPathBuilder(HTTPIngressPath instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withBackend(instance.getBackend());
        this.withPath(instance.getPath());
        this.withPathType(instance.getPathType());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public HTTPIngressPath build() {
        HTTPIngressPath buildable = new HTTPIngressPath(this.fluent.getBackend(), this.fluent.getPath(), this.fluent.getPathType());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPIngressPathBuilder that = (HTTPIngressPathBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

