/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.datafactory.models.RunQueryFilter;
import com.azure.resourcemanager.datafactory.models.RunQueryOrderBy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RunFilterParameters {
    @JsonProperty(value="continuationToken")
    private String continuationToken;
    @JsonProperty(value="lastUpdatedAfter", required=true)
    private OffsetDateTime lastUpdatedAfter;
    @JsonProperty(value="lastUpdatedBefore", required=true)
    private OffsetDateTime lastUpdatedBefore;
    @JsonProperty(value="filters")
    private List<RunQueryFilter> filters;
    @JsonProperty(value="orderBy")
    private List<RunQueryOrderBy> orderBy;
    private static final ClientLogger LOGGER = new ClientLogger(RunFilterParameters.class);

    public String continuationToken() {
        return this.continuationToken;
    }

    public RunFilterParameters withContinuationToken(String continuationToken) {
        this.continuationToken = continuationToken;
        return this;
    }

    public OffsetDateTime lastUpdatedAfter() {
        return this.lastUpdatedAfter;
    }

    public RunFilterParameters withLastUpdatedAfter(OffsetDateTime lastUpdatedAfter) {
        this.lastUpdatedAfter = lastUpdatedAfter;
        return this;
    }

    public OffsetDateTime lastUpdatedBefore() {
        return this.lastUpdatedBefore;
    }

    public RunFilterParameters withLastUpdatedBefore(OffsetDateTime lastUpdatedBefore) {
        this.lastUpdatedBefore = lastUpdatedBefore;
        return this;
    }

    public List<RunQueryFilter> filters() {
        return this.filters;
    }

    public RunFilterParameters withFilters(List<RunQueryFilter> filters) {
        this.filters = filters;
        return this;
    }

    public List<RunQueryOrderBy> orderBy() {
        return this.orderBy;
    }

    public RunFilterParameters withOrderBy(List<RunQueryOrderBy> orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public void validate() {
        if (this.lastUpdatedAfter() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property lastUpdatedAfter in model RunFilterParameters"));
        }
        if (this.lastUpdatedBefore() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property lastUpdatedBefore in model RunFilterParameters"));
        }
        if (this.filters() != null) {
            this.filters().forEach(e -> e.validate());
        }
        if (this.orderBy() != null) {
            this.orderBy().forEach(e -> e.validate());
        }
    }
}

