/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.dao.utils;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.dao.entity.WorkerGroup;

public class WorkerGroupUtils {
    private static final String DEFAULT_WORKER_GROUP = "default";

    public static boolean isWorkerGroupEmpty(String workerGroup) {
        return StringUtils.isEmpty((CharSequence)workerGroup) || WorkerGroupUtils.getDefaultWorkerGroup().equals(workerGroup);
    }

    public static String getWorkerGroupOrDefault(String workerGroup) {
        return WorkerGroupUtils.getWorkerGroupOrDefault(workerGroup, WorkerGroupUtils.getDefaultWorkerGroup());
    }

    public static String getWorkerGroupOrDefault(String workerGroup, String defaultWorkerGroup) {
        return WorkerGroupUtils.isWorkerGroupEmpty(workerGroup) ? defaultWorkerGroup : workerGroup;
    }

    public static String getDefaultWorkerGroup() {
        return DEFAULT_WORKER_GROUP;
    }

    public static List<String> getWorkerAddressListFromWorkerGroup(WorkerGroup workerGroup) {
        String addrList = workerGroup.getAddrList();
        if (StringUtils.isEmpty((CharSequence)addrList)) {
            return Collections.emptyList();
        }
        return Lists.newArrayList((Object[])addrList.split(","));
    }
}

