/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.metrics.AlertServerMetrics;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.registry.AlertRegistryClient;
import org.apache.dolphinscheduler.alert.rpc.AlertRpcServer;
import org.apache.dolphinscheduler.alert.service.AlertBootstrapService;
import org.apache.dolphinscheduler.alert.service.AlertHAServer;
import org.apache.dolphinscheduler.common.CommonConfiguration;
import org.apache.dolphinscheduler.common.constants.Constants;
import org.apache.dolphinscheduler.common.lifecycle.ServerLifeCycleManager;
import org.apache.dolphinscheduler.common.thread.DefaultUncaughtExceptionHandler;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.apache.dolphinscheduler.dao.DaoConfiguration;
import org.apache.dolphinscheduler.registry.api.RegistryConfiguration;
import org.apache.dolphinscheduler.registry.api.ha.AbstractServerStatusChangeListener;
import org.apache.dolphinscheduler.registry.api.ha.ServerStatusChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.context.annotation.Import;

@Import(value={CommonConfiguration.class, DaoConfiguration.class, RegistryConfiguration.class})
@SpringBootApplication
public class AlertServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertServer.class);
    @Autowired
    private AlertRpcServer alertRpcServer;
    @Autowired
    private AlertPluginManager alertPluginManager;
    @Autowired
    private AlertRegistryClient alertRegistryClient;
    @Autowired
    private AlertHAServer alertHAServer;
    @Autowired
    private AlertBootstrapService alertBootstrapService;

    public static void main(String[] args) {
        AlertServerMetrics.registerUncachedException(DefaultUncaughtExceptionHandler::getUncaughtExceptionCount);
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)DefaultUncaughtExceptionHandler.getInstance());
        Thread.currentThread().setName("Alert-Server");
        SpringApplication.run(AlertServer.class, (String[])args);
    }

    @PostConstruct
    public void run() {
        ServerLifeCycleManager.toRunning();
        log.info("AlertServer is staring ...");
        this.alertPluginManager.start();
        this.alertRpcServer.start();
        this.alertRegistryClient.start();
        this.alertHAServer.addServerStatusChangeListener((ServerStatusChangeListener)new AbstractServerStatusChangeListener(){

            public void changeToActive() {
                AlertServer.this.alertBootstrapService.start();
            }

            public void changeToStandBy() {
                AlertServer.this.close();
            }
        });
        this.alertHAServer.start();
        log.info("AlertServer is started ...");
    }

    @PreDestroy
    public void close() {
        String cause = "AlertServer destroy";
        try {
            if (!ServerLifeCycleManager.toStopped()) {
                log.warn("AlterServer is already stopped");
                return;
            }
            log.info("AlertServer is stopping, cause: {}", (Object)cause);
            try (AlertRpcServer ignore = this.alertRpcServer;
                 AlertRegistryClient ignore1 = this.alertRegistryClient;
                 AlertHAServer ignore2 = this.alertHAServer;){
                AlertBootstrapService ignore3 = this.alertBootstrapService;
                Throwable throwable = null;
                if (ignore3 != null) {
                    if (throwable != null) {
                        try {
                            ignore3.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        ignore3.close();
                    }
                }
            }
            ThreadUtils.sleep((long)Constants.SERVER_CLOSE_WAIT_TIME.toMillis());
            log.info("AlertServer stopped, cause: {}", (Object)cause);
        }
        catch (Exception e) {
            log.error("AlertServer stop failed, cause: {}", (Object)cause, (Object)e);
        }
    }
}

