/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.fluent.models.SiteAuthSettingsInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.BuiltInAuthenticationProvider;
import com.azure.resourcemanager.appservice.models.UnauthenticatedClientAction;
import com.azure.resourcemanager.appservice.models.WebAppAuthentication;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import java.util.ArrayList;

class WebAppAuthenticationImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteAuthSettingsInner>
implements WebAppAuthentication,
WebAppAuthentication.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppAuthentication.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;

    WebAppAuthenticationImpl(SiteAuthSettingsInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        this.parent = parent;
        inner.withTokenStoreEnabled(true);
    }

    public FluentImplT attach() {
        this.parent.withAuthentication(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        this.parent.withAuthentication(this);
        return (FluentImplT)this.parent;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withAnonymousAuthentication() {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withUnauthenticatedClientAction(UnauthenticatedClientAction.ALLOW_ANONYMOUS);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withDefaultAuthenticationProvider(BuiltInAuthenticationProvider provider) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withUnauthenticatedClientAction(UnauthenticatedClientAction.REDIRECT_TO_LOGIN_PAGE).withDefaultProvider(provider);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withActiveDirectory(String clientId, String issuerUrl) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withClientId(clientId).withIssuer(issuerUrl);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withFacebook(String appId, String appSecret) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withFacebookAppId(appId).withFacebookAppSecret(appSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withGoogle(String clientId, String clientSecret) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withGoogleClientId(clientId).withGoogleClientSecret(clientSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withTwitter(String apiKey, String apiSecret) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withTwitterConsumerKey(apiKey).withTwitterConsumerSecret(apiSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withMicrosoft(String clientId, String clientSecret) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withMicrosoftAccountClientId(clientId).withMicrosoftAccountClientSecret(clientSecret);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withTokenStore(boolean enabled) {
        ((SiteAuthSettingsInner)((Object)this.innerModel())).withTokenStoreEnabled(enabled);
        return this;
    }

    public WebAppAuthenticationImpl<FluentT, FluentImplT> withAllowedExternalRedirectUrl(String url) {
        if (((SiteAuthSettingsInner)((Object)this.innerModel())).allowedExternalRedirectUrls() == null) {
            ((SiteAuthSettingsInner)((Object)this.innerModel())).withAllowedExternalRedirectUrls(new ArrayList<String>());
        }
        ((SiteAuthSettingsInner)((Object)this.innerModel())).allowedExternalRedirectUrls().add(url);
        return this;
    }
}

