/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.task.executor.worker;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.apache.dolphinscheduler.task.executor.ITaskExecutor;
import org.apache.dolphinscheduler.task.executor.log.TaskExecutorMDCUtils;
import org.apache.dolphinscheduler.task.executor.worker.AbstractTaskExecutorWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskExecutorWorker
extends AbstractTaskExecutorWorker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskExecutorWorker.class);
    private final Map<Integer, ITaskExecutor> registeredTaskExecutors = new ConcurrentHashMap<Integer, ITaskExecutor>();
    private final Map<Integer, ITaskExecutor> activeTaskExecutors = new ConcurrentHashMap<Integer, ITaskExecutor>();
    private final Lock activeTaskExecutorsChangeLock = new ReentrantLock();
    private final Condition activeTaskExecutorEmptyCondition = this.activeTaskExecutorsChangeLock.newCondition();
    private final int workerId;

    public TaskExecutorWorker(int workerId) {
        this.workerId = workerId;
    }

    @Override
    public int getId() {
        return this.workerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        while (true) {
            long minNextTrackDelay = 100L;
            for (ITaskExecutor taskExecutor : this.activeTaskExecutors.values()) {
                TaskExecutorMDCUtils.MDCAutoClosable closable = TaskExecutorMDCUtils.logWithMDC(taskExecutor);
                Throwable throwable = null;
                try {
                    try {
                        long remainingTrackDelay;
                        if (!taskExecutor.isStarted()) {
                            taskExecutor.start();
                        }
                        if ((remainingTrackDelay = taskExecutor.getRemainingTrackDelay()) > 0L) {
                            minNextTrackDelay = Math.min(minNextTrackDelay, remainingTrackDelay);
                            continue;
                        }
                        this.trackTaskExecutorState(taskExecutor);
                    }
                    catch (Throwable e) {
                        log.error("{} execute failed", (Object)taskExecutor, (Object)e);
                        this.onTaskExecutorFailed(taskExecutor);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (closable == null) continue;
                    if (throwable != null) {
                        try {
                            closable.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    closable.close();
                }
            }
            this.activeTaskExecutorsChangeLock.lock();
            try {
                if (this.activeTaskExecutors.isEmpty()) {
                    this.activeTaskExecutorEmptyCondition.await();
                    continue;
                }
                this.activeTaskExecutorEmptyCondition.await(minNextTrackDelay, TimeUnit.MILLISECONDS);
                continue;
            }
            catch (InterruptedException e) {
                log.info("TaskExecutorWorker(id={}) is interrupted", (Object)this.workerId, (Object)e);
            }
            finally {
                this.activeTaskExecutorsChangeLock.unlock();
                continue;
            }
            break;
        }
    }

    @Override
    public void registerTaskExecutor(ITaskExecutor taskExecutor) {
        Integer taskExecutorId = taskExecutor.getId();
        if (this.registeredTaskExecutors.containsKey(taskExecutorId)) {
            throw new IllegalStateException("The TaskExecutorWorker has already registered " + taskExecutor);
        }
        this.registeredTaskExecutors.put(taskExecutorId, taskExecutor);
    }

    @Override
    public void unRegisterTaskExecutor(ITaskExecutor taskExecutor) {
        Integer taskExecutorId = taskExecutor.getId();
        if (!this.registeredTaskExecutors.containsKey(taskExecutorId)) {
            throw new IllegalStateException("The TaskExecutorWorker has not registered " + taskExecutor);
        }
        this.registeredTaskExecutors.remove(taskExecutorId);
    }

    @Override
    public void fireTaskExecutor(ITaskExecutor taskExecutor) {
        this.activeTaskExecutorsChangeLock.lock();
        try {
            Integer taskExecutorId = taskExecutor.getId();
            if (!this.registeredTaskExecutors.containsKey(taskExecutorId)) {
                throw new IllegalStateException("The TaskExecutorWorker has not registered " + taskExecutor);
            }
            if (this.activeTaskExecutors.containsKey(taskExecutorId)) {
                throw new IllegalStateException("The TaskExecutorWorker has already fired " + taskExecutor);
            }
            this.activeTaskExecutors.put(taskExecutorId, taskExecutor);
            this.activeTaskExecutorEmptyCondition.signalAll();
        }
        finally {
            this.activeTaskExecutorsChangeLock.unlock();
        }
    }

    @Override
    public void unFireTaskExecutor(ITaskExecutor taskExecutor) {
        try {
            this.activeTaskExecutorsChangeLock.lock();
            Integer taskExecutorId = taskExecutor.getId();
            this.activeTaskExecutors.remove(taskExecutorId);
        }
        finally {
            this.activeTaskExecutorsChangeLock.unlock();
        }
    }

    @Override
    public int getRegisteredTaskExecutorSize() {
        return this.registeredTaskExecutors.size();
    }

    @Override
    public int getFiredTaskExecutorSize() {
        return this.activeTaskExecutors.size();
    }

    @Generated
    public int getWorkerId() {
        return this.workerId;
    }
}

