/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetManagedDiskParameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class VirtualMachineScaleSetOSDisk {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="caching")
    private CachingTypes caching;
    @JsonProperty(value="writeAcceleratorEnabled")
    private Boolean writeAcceleratorEnabled;
    @JsonProperty(value="createOption", required=true)
    private DiskCreateOptionTypes createOption;
    @JsonProperty(value="diffDiskSettings")
    private DiffDiskSettings diffDiskSettings;
    @JsonProperty(value="diskSizeGB")
    private Integer diskSizeGB;
    @JsonProperty(value="osType")
    private OperatingSystemTypes osType;
    @JsonProperty(value="image")
    private VirtualHardDisk image;
    @JsonProperty(value="vhdContainers")
    private List<String> vhdContainers;
    @JsonProperty(value="managedDisk")
    private VirtualMachineScaleSetManagedDiskParameters managedDisk;
    @JsonProperty(value="deleteOption")
    private DiskDeleteOptionTypes deleteOption;
    private static final ClientLogger LOGGER = new ClientLogger(VirtualMachineScaleSetOSDisk.class);

    public String name() {
        return this.name;
    }

    public VirtualMachineScaleSetOSDisk withName(String name) {
        this.name = name;
        return this;
    }

    public CachingTypes caching() {
        return this.caching;
    }

    public VirtualMachineScaleSetOSDisk withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    public VirtualMachineScaleSetOSDisk withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    public DiskCreateOptionTypes createOption() {
        return this.createOption;
    }

    public VirtualMachineScaleSetOSDisk withCreateOption(DiskCreateOptionTypes createOption) {
        this.createOption = createOption;
        return this;
    }

    public DiffDiskSettings diffDiskSettings() {
        return this.diffDiskSettings;
    }

    public VirtualMachineScaleSetOSDisk withDiffDiskSettings(DiffDiskSettings diffDiskSettings) {
        this.diffDiskSettings = diffDiskSettings;
        return this;
    }

    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    public VirtualMachineScaleSetOSDisk withDiskSizeGB(Integer diskSizeGB) {
        this.diskSizeGB = diskSizeGB;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public VirtualMachineScaleSetOSDisk withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public VirtualHardDisk image() {
        return this.image;
    }

    public VirtualMachineScaleSetOSDisk withImage(VirtualHardDisk image) {
        this.image = image;
        return this;
    }

    public List<String> vhdContainers() {
        return this.vhdContainers;
    }

    public VirtualMachineScaleSetOSDisk withVhdContainers(List<String> vhdContainers) {
        this.vhdContainers = vhdContainers;
        return this;
    }

    public VirtualMachineScaleSetManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    public VirtualMachineScaleSetOSDisk withManagedDisk(VirtualMachineScaleSetManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    public VirtualMachineScaleSetOSDisk withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    public void validate() {
        if (this.createOption() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property createOption in model VirtualMachineScaleSetOSDisk"));
        }
        if (this.diffDiskSettings() != null) {
            this.diffDiskSettings().validate();
        }
        if (this.image() != null) {
            this.image().validate();
        }
        if (this.managedDisk() != null) {
            this.managedDisk().validate();
        }
    }
}

