/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.registry.zookeeper;

import java.time.Duration;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Configuration
@ConditionalOnProperty(prefix="registry", name={"type"}, havingValue="zookeeper")
@ConfigurationProperties(prefix="registry")
public class ZookeeperRegistryProperties
implements Validator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ZookeeperRegistryProperties.class);
    private ZookeeperProperties zookeeper = new ZookeeperProperties();
    private String type;

    public boolean supports(Class<?> clazz) {
        return ZookeeperRegistryProperties.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        ZookeeperProperties zookeeper;
        ZookeeperRegistryProperties zookeeperRegistryProperties = (ZookeeperRegistryProperties)target;
        if (zookeeperRegistryProperties.getZookeeper() == null) {
            errors.rejectValue("zookeeper", "zookeeper", "zookeeper properties is required");
        }
        if (StringUtils.isEmpty((CharSequence)(zookeeper = zookeeperRegistryProperties.getZookeeper()).getNamespace())) {
            errors.rejectValue("zookeeper.namespace", "", "zookeeper.namespace cannot be null");
        }
        if (StringUtils.isEmpty((CharSequence)zookeeper.getConnectString())) {
            errors.rejectValue("zookeeper.connectString", "", "zookeeper.connectString cannot be null");
        }
        if (zookeeper.getRetryPolicy() == null) {
            errors.rejectValue("zookeeper.retryPolicy", "", "zookeeper.retryPolicy cannot be null");
        }
        if (zookeeper.getSessionTimeout() == null || zookeeper.getSessionTimeout().isZero() || zookeeper.getSessionTimeout().isNegative()) {
            errors.rejectValue("zookeeper.sessionTimeout", "", "zookeeper.sessionTimeout should be positive");
        }
        if (zookeeper.getConnectionTimeout() == null || zookeeper.getConnectionTimeout().isZero() || zookeeper.getConnectionTimeout().isNegative()) {
            errors.rejectValue("zookeeper.connectionTimeout", "", "zookeeper.connectionTimeout should be positive");
        }
        if (zookeeper.getBlockUntilConnected() == null || zookeeper.getBlockUntilConnected().isZero() || zookeeper.getBlockUntilConnected().isNegative()) {
            errors.rejectValue("zookeeper.blockUntilConnected", "", "zookeeper.blockUntilConnected should be positive");
        }
        this.printConfig();
    }

    private void printConfig() {
        String config = "\n****************************ZookeeperRegistryProperties**************************************\n  namespace -> " + this.zookeeper.getNamespace() + "\n  connectString -> " + this.zookeeper.getConnectString() + "\n  retryPolicy -> " + this.zookeeper.getRetryPolicy() + "\n  digest -> " + this.zookeeper.getDigest() + "\n  sessionTimeout -> " + this.zookeeper.getSessionTimeout() + "\n  connectionTimeout -> " + this.zookeeper.getConnectionTimeout() + "\n  blockUntilConnected -> " + this.zookeeper.getBlockUntilConnected() + "\n****************************ZookeeperRegistryProperties**************************************";
        log.info(config);
    }

    @Generated
    public ZookeeperProperties getZookeeper() {
        return this.zookeeper;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public void setZookeeper(ZookeeperProperties zookeeper) {
        this.zookeeper = zookeeper;
    }

    @Generated
    public void setType(String type) {
        this.type = type;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZookeeperRegistryProperties)) {
            return false;
        }
        ZookeeperRegistryProperties other = (ZookeeperRegistryProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ZookeeperProperties this$zookeeper = this.getZookeeper();
        ZookeeperProperties other$zookeeper = other.getZookeeper();
        if (this$zookeeper == null ? other$zookeeper != null : !((Object)this$zookeeper).equals(other$zookeeper)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ZookeeperRegistryProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ZookeeperProperties $zookeeper = this.getZookeeper();
        result = result * 59 + ($zookeeper == null ? 43 : ((Object)$zookeeper).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ZookeeperRegistryProperties(zookeeper=" + this.getZookeeper() + ", type=" + this.getType() + ")";
    }

    @Generated
    public ZookeeperRegistryProperties() {
    }

    @Generated
    public ZookeeperRegistryProperties(ZookeeperProperties zookeeper, String type) {
        this.zookeeper = zookeeper;
        this.type = type;
    }

    public static final class ZookeeperProperties {
        private String namespace = "dolphinscheduler";
        private String connectString;
        private RetryPolicy retryPolicy = new RetryPolicy();
        private String digest;
        private Duration sessionTimeout = Duration.ofSeconds(60L);
        private Duration connectionTimeout = Duration.ofSeconds(15L);
        private Duration blockUntilConnected = Duration.ofSeconds(15L);

        @Generated
        public ZookeeperProperties() {
        }

        @Generated
        public String getNamespace() {
            return this.namespace;
        }

        @Generated
        public String getConnectString() {
            return this.connectString;
        }

        @Generated
        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        @Generated
        public String getDigest() {
            return this.digest;
        }

        @Generated
        public Duration getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Generated
        public Duration getConnectionTimeout() {
            return this.connectionTimeout;
        }

        @Generated
        public Duration getBlockUntilConnected() {
            return this.blockUntilConnected;
        }

        @Generated
        public void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Generated
        public void setConnectString(String connectString) {
            this.connectString = connectString;
        }

        @Generated
        public void setRetryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
        }

        @Generated
        public void setDigest(String digest) {
            this.digest = digest;
        }

        @Generated
        public void setSessionTimeout(Duration sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Generated
        public void setConnectionTimeout(Duration connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
        }

        @Generated
        public void setBlockUntilConnected(Duration blockUntilConnected) {
            this.blockUntilConnected = blockUntilConnected;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ZookeeperProperties)) {
                return false;
            }
            ZookeeperProperties other = (ZookeeperProperties)o;
            String this$namespace = this.getNamespace();
            String other$namespace = other.getNamespace();
            if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
                return false;
            }
            String this$connectString = this.getConnectString();
            String other$connectString = other.getConnectString();
            if (this$connectString == null ? other$connectString != null : !this$connectString.equals(other$connectString)) {
                return false;
            }
            RetryPolicy this$retryPolicy = this.getRetryPolicy();
            RetryPolicy other$retryPolicy = other.getRetryPolicy();
            if (this$retryPolicy == null ? other$retryPolicy != null : !((Object)this$retryPolicy).equals(other$retryPolicy)) {
                return false;
            }
            String this$digest = this.getDigest();
            String other$digest = other.getDigest();
            if (this$digest == null ? other$digest != null : !this$digest.equals(other$digest)) {
                return false;
            }
            Duration this$sessionTimeout = this.getSessionTimeout();
            Duration other$sessionTimeout = other.getSessionTimeout();
            if (this$sessionTimeout == null ? other$sessionTimeout != null : !((Object)this$sessionTimeout).equals(other$sessionTimeout)) {
                return false;
            }
            Duration this$connectionTimeout = this.getConnectionTimeout();
            Duration other$connectionTimeout = other.getConnectionTimeout();
            if (this$connectionTimeout == null ? other$connectionTimeout != null : !((Object)this$connectionTimeout).equals(other$connectionTimeout)) {
                return false;
            }
            Duration this$blockUntilConnected = this.getBlockUntilConnected();
            Duration other$blockUntilConnected = other.getBlockUntilConnected();
            return !(this$blockUntilConnected == null ? other$blockUntilConnected != null : !((Object)this$blockUntilConnected).equals(other$blockUntilConnected));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $namespace = this.getNamespace();
            result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
            String $connectString = this.getConnectString();
            result = result * 59 + ($connectString == null ? 43 : $connectString.hashCode());
            RetryPolicy $retryPolicy = this.getRetryPolicy();
            result = result * 59 + ($retryPolicy == null ? 43 : ((Object)$retryPolicy).hashCode());
            String $digest = this.getDigest();
            result = result * 59 + ($digest == null ? 43 : $digest.hashCode());
            Duration $sessionTimeout = this.getSessionTimeout();
            result = result * 59 + ($sessionTimeout == null ? 43 : ((Object)$sessionTimeout).hashCode());
            Duration $connectionTimeout = this.getConnectionTimeout();
            result = result * 59 + ($connectionTimeout == null ? 43 : ((Object)$connectionTimeout).hashCode());
            Duration $blockUntilConnected = this.getBlockUntilConnected();
            result = result * 59 + ($blockUntilConnected == null ? 43 : ((Object)$blockUntilConnected).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ZookeeperRegistryProperties.ZookeeperProperties(namespace=" + this.getNamespace() + ", connectString=" + this.getConnectString() + ", retryPolicy=" + this.getRetryPolicy() + ", digest=" + this.getDigest() + ", sessionTimeout=" + this.getSessionTimeout() + ", connectionTimeout=" + this.getConnectionTimeout() + ", blockUntilConnected=" + this.getBlockUntilConnected() + ")";
        }

        public static final class RetryPolicy {
            private Duration baseSleepTime = Duration.ofSeconds(1L);
            private int maxRetries = 3;
            private Duration maxSleep = Duration.ofSeconds(3L);

            @Generated
            public RetryPolicy() {
            }

            @Generated
            public Duration getBaseSleepTime() {
                return this.baseSleepTime;
            }

            @Generated
            public int getMaxRetries() {
                return this.maxRetries;
            }

            @Generated
            public Duration getMaxSleep() {
                return this.maxSleep;
            }

            @Generated
            public void setBaseSleepTime(Duration baseSleepTime) {
                this.baseSleepTime = baseSleepTime;
            }

            @Generated
            public void setMaxRetries(int maxRetries) {
                this.maxRetries = maxRetries;
            }

            @Generated
            public void setMaxSleep(Duration maxSleep) {
                this.maxSleep = maxSleep;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof RetryPolicy)) {
                    return false;
                }
                RetryPolicy other = (RetryPolicy)o;
                if (this.getMaxRetries() != other.getMaxRetries()) {
                    return false;
                }
                Duration this$baseSleepTime = this.getBaseSleepTime();
                Duration other$baseSleepTime = other.getBaseSleepTime();
                if (this$baseSleepTime == null ? other$baseSleepTime != null : !((Object)this$baseSleepTime).equals(other$baseSleepTime)) {
                    return false;
                }
                Duration this$maxSleep = this.getMaxSleep();
                Duration other$maxSleep = other.getMaxSleep();
                return !(this$maxSleep == null ? other$maxSleep != null : !((Object)this$maxSleep).equals(other$maxSleep));
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getMaxRetries();
                Duration $baseSleepTime = this.getBaseSleepTime();
                result = result * 59 + ($baseSleepTime == null ? 43 : ((Object)$baseSleepTime).hashCode());
                Duration $maxSleep = this.getMaxSleep();
                result = result * 59 + ($maxSleep == null ? 43 : ((Object)$maxSleep).hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "ZookeeperRegistryProperties.ZookeeperProperties.RetryPolicy(baseSleepTime=" + this.getBaseSleepTime() + ", maxRetries=" + this.getMaxRetries() + ", maxSleep=" + this.getMaxSleep() + ")";
            }
        }
    }
}

